/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.msm.log.service.impl;

import cn.com.yusys.yusp.msm.exception.DashboardParamException;
import cn.com.yusys.yusp.msm.log.domain.OperationLog;
import cn.com.yusys.yusp.msm.log.repository.mapper.OperationLogDBMapper;
import cn.com.yusys.yusp.msm.log.service.OperationLogService;
import cn.com.yusys.yusp.msm.storage.service.StorageType;
import com.github.pagehelper.PageHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@StorageType(serviceType="database")
public class OperationLogServiceDBImpl
implements OperationLogService {
    @Autowired
    private OperationLogDBMapper mapper;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    public Map<String, List<OperationLog>> getMap() {
        return (Map)((Object)this.mapper.getOperationMap());
    }

    @Override
    public void insert(OperationLog operationLog) throws DashboardParamException {
        operationLog.setOpTime(this.sdf.format(new Date()));
        this.mapper.addMap(operationLog);
    }

    @Override
    public List<OperationLog> getListByName(String name, int num) {
        PageHelper.startPage((int)num, (int)50);
        List<OperationLog> list = this.mapper.getListByName(name);
        return list;
    }
}

