/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.msm.log.repository;

import cn.com.yusys.yusp.msm.config.ConfigFileConfiguration;
import cn.com.yusys.yusp.msm.exception.DashboardFileException;
import cn.com.yusys.yusp.msm.exception.DashboardParamException;
import cn.com.yusys.yusp.msm.log.domain.OperationLog;
import cn.com.yusys.yusp.msm.log.domain.OperationLogMap;
import cn.com.yusys.yusp.msm.log.repository.CommonRepository;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Repository;

@Repository
@EnableConfigurationProperties(value={ConfigFileConfiguration.class})
public class OperationLogRepository
extends CommonRepository {
    private final Logger log = LoggerFactory.getLogger(OperationLogRepository.class);

    public OperationLogRepository(ConfigFileConfiguration properties) {
        super(properties.getOperationLog());
        this.log.debug("properties:{}", (Object)properties);
    }

    @Override
    public JavaType getJavaType() {
        return TypeFactory.defaultInstance().constructType(OperationLogMap.class);
    }

    public OperationLogMap getOperationLogMap() {
        OperationLogMap operationLogList = (OperationLogMap)this.getLoadObj();
        if (operationLogList == null) {
            this.log.debug("operationLogList is null");
            operationLogList = new OperationLogMap();
        }
        if (operationLogList.getOperationMap() == null) {
            this.log.debug("operationLogList.operationList is null");
            operationLogList.setOperationMap(new HashMap<String, List<OperationLog>>());
        }
        return operationLogList;
    }

    public Map<String, List<OperationLog>> getMap() {
        return this.getOperationLogMap().getOperationMap();
    }

    public List<OperationLog> getListByName(String name) {
        this.log.debug("query list, name:{}", (Object)name);
        ArrayList list = this.getOperationLogMap().getOperationMap().get(name);
        return list == null ? new ArrayList() : list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(OperationLog operationLog) throws DashboardParamException {
        OperationLogRepository operationLogRepository = this;
        synchronized (operationLogRepository) {
            this.log.debug("insert entity , entity info :{}", (Object)operationLog);
            OperationLogMap operationLogMap = this.getOperationLogMap();
            List<OperationLog> logList = this.getListByName(operationLog.getName());
            logList.add(operationLog);
            operationLogMap.getOperationMap().put(operationLog.getName(), logList);
            try {
                this.getAfo().writeObject(operationLogMap);
            }
            catch (DashboardFileException e) {
                this.log.error("insert entity error, message:{}", (Object)e.getMessage());
                e.printStackTrace();
            }
            this.log.debug("insert entity , success");
        }
    }
}

