/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.msm.log.repository;

import cn.com.yusys.yusp.msm.common.AbstractFileObject;
import cn.com.yusys.yusp.msm.common.FileObjectFactory;
import cn.com.yusys.yusp.msm.config.CommonProperties;
import cn.com.yusys.yusp.msm.exception.DashboardFileException;
import cn.com.yusys.yusp.msm.exception.DashboardParamException;
import cn.com.yusys.yusp.msm.ssh.Utils;
import cn.com.yusys.yusp.msm.util.ObjectUtils;
import com.fasterxml.jackson.databind.JavaType;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonRepository {
    private final Logger logger = LoggerFactory.getLogger(CommonRepository.class);
    private final CommonProperties properties;
    private AbstractFileObject afo;

    public CommonRepository(CommonProperties properties) {
        this.properties = properties;
    }

    private void init() {
        try {
            this.afo = FileObjectFactory.getFileObject(Utils.handlePath(this.properties.getPath()), this.getJavaType(), this.properties.getType());
        }
        catch (DashboardFileException e) {
            e.printStackTrace();
            this.logger.debug(e.getMessage());
        }
    }

    public AbstractFileObject getAfo() {
        return this.afo;
    }

    public Object getLoadObj() {
        return this.afo.getObj();
    }

    public abstract JavaType getJavaType();

    public int writeObject(Object o) {
        int code = 0;
        try {
            this.afo.writeObject(o);
        }
        catch (DashboardFileException e) {
            e.printStackTrace();
            code = 1;
        }
        return code;
    }

    public boolean merge(Object src, Object old) {
        boolean success = true;
        try {
            ObjectUtils.merge(src, old);
        }
        catch (DashboardParamException | IllegalAccessException e) {
            e.printStackTrace();
            success = false;
        }
        return success;
    }

    protected boolean updateList(List list, Object o, Field field, boolean merge) {
        boolean success = true;
        if (field == null) {
            if (!list.contains(o)) {
                success = list.add(o);
            }
        } else {
            int count = 0;
            field.setAccessible(true);
            try {
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) == null || !field.get(o).equals(field.get(list.get(i)))) continue;
                    if (merge) {
                        success = this.merge(o, list.get(i));
                    }
                    list.set(i, o);
                    ++count;
                    break;
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (count == 0) {
                success = list.add(o);
            }
        }
        return success;
    }

    public boolean removeByKeys(List list, Field field, Object[] keys) {
        boolean success = false;
        if (keys != null && list != null && field != null) {
            try {
                field.setAccessible(true);
                Iterator iterator = list.iterator();
                block2: while (iterator.hasNext()) {
                    Object k = field.get(iterator.next());
                    for (Object key : keys) {
                        if (key == null || !key.equals(k)) continue;
                        iterator.remove();
                        continue block2;
                    }
                }
                success = true;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return success;
    }
}

