/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.license;

import cn.com.yusys.license.DESUtils;
import cn.com.yusys.license.LicenseManager;
import cn.com.yusys.license.MacUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VerityLicenseAssist {
    private static final String APP_MAC = "app_machine_code";
    private static final String APP_BUILD = "app_build_time";
    private String filepath;
    private HashMap<String, String> el = new HashMap();

    public VerityLicenseAssist() {
        this.initFilepath();
        if (!this.isExist()) {
            this.createXml();
        } else if (!this.parse() && !this.vaMacCode()) {
            this.createXml();
        }
    }

    private void initFilepath() {
        String licfile = LicenseManager.getInstance().getLicenseFile();
        this.filepath = licfile.split("\\.lic")[0];
    }

    private boolean isExist() {
        File file = new File(this.filepath);
        return file.exists() && file.isFile();
    }

    private void createXml() {
        String c = MacUtil.getMacAddress();
        String time = new Date().toString();
        this.write2File(c, time);
        this.el.put(APP_MAC, c);
        this.el.put(APP_BUILD, time);
    }

    private void write2File(String c, String time) {
        Document doc = this.buildDoc(c, time);
        this.write(doc);
    }

    private void write(Document doc) {
        File file = new File(this.filepath);
        try {
            file.createNewFile();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        TransformerFactory tff = TransformerFactory.newInstance();
        try {
            Transformer tf = tff.newTransformer();
            tf.transform(new DOMSource(doc), new StreamResult(this.filepath));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private Document buildDoc(String c, String time) {
        String enc = DESUtils.getEncryptString(c);
        String entime = DESUtils.getEncryptString(time);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
            Element root = doc.createElement("license");
            doc.appendChild(root);
            Element element1 = doc.createElement("element");
            element1.setTextContent(enc);
            element1.setAttribute("name", APP_MAC);
            root.appendChild(element1);
            Element element2 = doc.createElement("element");
            element2.setTextContent(entime);
            element2.setAttribute("name", APP_BUILD);
            root.appendChild(element2);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return doc;
    }

    private boolean parse() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(this.filepath);
            NodeList elements = doc.getElementsByTagName("element");
            if (elements != null && elements.getLength() > 0) {
                for (int i = 0; i < elements.getLength(); ++i) {
                    Element e = (Element)elements.item(i);
                    String name = e.getAttribute("name");
                    String value = DESUtils.getDecryptString(e.getTextContent());
                    this.el.put(name, value);
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean vaMacCode() {
        String macCode = MacUtil.getMacAddress();
        return macCode != null && macCode.equals(this.el.get(APP_MAC));
    }

    public boolean valAppBuildTime(String licBtime) {
        long licbTimt = new Date(licBtime).getTime();
        long appBtime = new Date(this.el.get(APP_BUILD)).getTime();
        long tim = (appBtime - licbTimt) / 86400000L;
        return tim <= 30L && tim >= 0L;
    }
}

