/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.license;

import cn.com.yusys.license.LicenseException;
import cn.com.yusys.license.ResourceUtils;
import cn.com.yusys.license.VerityLicenseAssist;
import com.yuchenglicense.LicenseVerify;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class LicenseManager {
    private static Logger log = Logger.getLogger(LicenseManager.class);
    static final String LISENCE_DEV = "TRIAL";
    static final String LISENCE_DEP = "PRO";
    static final String licenseType = "\u5ba2\u6237\u9500\u552e\u8bb8\u53ef\u8bc1";
    static final int DAYS = 30;
    static String LISENCE_ERROR = "License\u8d85\u8fc7\u89c4\u5b9a\u65f6\u95f4\u672a\u542f\u7528\uff0c\u5df2\u5931\u6548\uff01\u8bf7\u60a8\u8054\u7cfb\u9500\u552e\u91cd\u65b0\u7533\u8bf7\uff01";
    private String licenseModel = "PRO";
    private String licenseFile = "";
    private InputStream inputStream = null;
    private boolean verified = false;
    private LicenseVerify licenseVerify;
    private String licensePath = ResourceUtils.getFilePath(LicenseManager.class) + File.separator;
    private static LicenseManager instance;

    public static LicenseManager getInstance() {
        if (instance == null) {
            instance = new LicenseManager();
        }
        return instance;
    }

    public void initialize() {
        this.verified = this.verifyLicense();
        if (!this.verified) {
            String errmsg = this.licenseVerify != null ? String.valueOf(this.licenseVerify.getErrorMessage()) + this.getLicenseInfo() : "license\u6587\u4ef6\u8def\u5f84\u914d\u7f6e\u9519\u8bef ";
            errmsg = "".equals(errmsg) ? LISENCE_ERROR : errmsg;
            throw new LicenseException(errmsg);
        }
    }

    private boolean verifyLicense() {
        try {
            if (this.inputStream == null) {
                File file = new File(this.licenseFile);
                if (!file.exists()) {
                    this.licenseFile = this.licensePath + this.licenseFile;
                    file = new File(this.licenseFile);
                }
                if (!file.exists()) {
                    return false;
                }
                this.inputStream = new FileInputStream(file);
            }
            this.licenseVerify = new LicenseVerify(this.inputStream);
            if (!this.licenseVerify.licenseValid()) {
                log.error((Object)this.licenseVerify.getErrorMessage());
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (!LISENCE_DEV.equals(this.licenseModel) && !LISENCE_DEP.equals(this.licenseModel) || LISENCE_DEV.equals(this.licenseModel) && this.valLicenseModel() || LISENCE_DEP.equals(this.licenseModel) && !this.valLicenseModel()) {
            log.error((Object)"license\u6587\u4ef6\u6a21\u5f0f\u914d\u7f6e\u9519\u8bef ");
            return false;
        }
        if (LISENCE_DEP.equals(this.licenseModel) && !this.assistVerify()) {
            log.error((Object)LISENCE_ERROR);
            return false;
        }
        log.info((Object)this.getLicenseInfo());
        return true;
    }

    private boolean valLicenseModel() {
        return licenseType.equals(this.licenseVerify.getLicenseType());
    }

    private boolean assistVerify() {
        VerityLicenseAssist ass = new VerityLicenseAssist();
        return ass.valAppBuildTime(this.licenseVerify.getBuildTime());
    }

    private String getLicenseInfo() {
        StringBuilder lic = new StringBuilder();
        lic.append("\n\t\u8bb8\u53ef\u8bc1\u521b\u5efa\u65f6\u95f4:").append(this.licenseVerify.getBuildTime());
        lic.append("\n\t\u8bb8\u53ef\u8bc1\u7f16\u53f7:").append(this.licenseVerify.getLicenseCode());
        lic.append("\n\t\u4ea7\u54c1\u7f16\u53f7:").append(this.licenseVerify.getProductCode());
        lic.append("\n\t\u4ea7\u54c1\u4e2d\u6587\u540d\u79f0:").append(this.licenseVerify.getProductNameZh());
        lic.append("\n\t\u4ea7\u54c1\u82f1\u6587\u7f29\u5199\u540d\u79f0:").append(this.licenseVerify.getProductNameEn());
        lic.append("\n\t\u4ea7\u54c1\u7248\u672c\u53f7:").append(this.licenseVerify.getVersionMajor()).append('.').append(this.licenseVerify.getVersionSub()).append('.').append(this.licenseVerify.getVersionPublish());
        lic.append("\n\t\u4ea7\u54c1\u7f16\u8bd1\u65e5\u671f:").append(this.licenseVerify.getComplieDate());
        lic.append("\n\t\u4ea7\u54c1\u8bb8\u53ef\u8bc1\u7c7b\u578b:").append(this.licenseVerify.getLicenseType());
        lic.append("\n\t\u4ea7\u54c1\u5ba2\u6237\u4f7f\u7528\u540d\u79f0:").append(this.licenseVerify.getCustomerName());
        lic.append("\n\t\u4ea7\u54c1\u9500\u552e\u5408\u540c\u53f7:").append(this.licenseVerify.getContractCode());
        lic.append("\n\t\u8d77\u59cb\u65e5\u671f:").append(this.licenseVerify.getLicenseStartTime());
        lic.append("\n\t\u7ec8\u6b62\u65e5\u671f:").append(this.licenseVerify.getLicenseEndTime());
        return lic.toString();
    }

    public LicenseVerify getLicenseVerify() {
        return this.licenseVerify;
    }

    public String getLicenseModel() {
        return this.licenseModel;
    }

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    public String getLicenseFile() {
        return this.licenseFile;
    }

    public void setLicenseFile(String licenseFile) {
        this.licenseFile = licenseFile;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public static void main(String[] args) {
        LicenseManager lm = new LicenseManager();
        lm.initialize();
    }
}

