/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.flow.util;

import cn.com.yusys.yusp.commons.i18n.MessageUtils;
import java.io.IOException;
import java.util.Arrays;

public class ExceptionUtil {
    private static String DIRECT_EXCEPTION_DESC = MessageUtils.getDefaultMessage((String)"wf_exception_msg_001", (String)"\u76f4\u63a5\u629b\u51fa\u7684\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a\\t[%s];\\n", (Object[])new Object[0]);
    private static String DIRECT_EXCEPTION_DESC_DETAIL_HEAD = MessageUtils.getDefaultMessage((String)"wf_exception_msg_002", (String)"- \u4e0a\u9762\u7684\u5f02\u5e38\u7531%s\u7c7b\u7684%s\u65b9\u6cd5\u7b2c%d\u884c\uff0c\u629b\u51fa\u7684", (Object[])new Object[0]);
    private static String DIRECT_EXCEPTION_DESC_DETAIL_TAIL = MessageUtils.getDefaultMessage((String)"wf_exception_msg_003", (String)"[%s]\u5f02\u5e38\u5bfc\u81f4\n", (Object[])new Object[0]);
    private static String ROOT_EXCEPTION_DESC = MessageUtils.getDefaultMessage((String)"wf_exception_msg_004", (String)"\u629b\u51fa\u5f02\u5e38\u7684\u6e90\u5934\u4e3a\uff1a\t[%s\u7c7b\u7684%s\u65b9\u6cd5\u7b2c%d\u884c]\n", (Object[])new Object[0]);
    private static String ROOT_EXCEPTION_DESC_DETAIL = MessageUtils.getDefaultMessage((String)"wf_exception_msg_005", (String)"\u8be5\u65b9\u6cd5\u88ab\u4ee5\u4e0b\u7c7b\u65b9\u6cd5\u8c03\u7528\uff1a\n", (Object[])new Object[0]);

    private ExceptionUtil() {
    }

    public static String getExceptionString(Exception ex) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(DIRECT_EXCEPTION_DESC, ex));
        String space = "";
        Throwable lastCause = ex;
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            space = space + " ";
            sb.append(space);
            StackTraceElement[] stackTrace1 = cause.getStackTrace();
            Arrays.stream(stackTrace1).map(stackTraceElement1 -> String.format(DIRECT_EXCEPTION_DESC_DETAIL_HEAD, stackTraceElement1.getClassName(), stackTraceElement1.getMethodName(), stackTraceElement1.getLineNumber())).findFirst().ifPresent(sb::append);
            sb.append(String.format(DIRECT_EXCEPTION_DESC_DETAIL_TAIL, cause));
            if (cause.getCause() == null) continue;
            lastCause = cause.getCause();
        }
        StackTraceElement[] stackTrace = lastCause.getStackTrace();
        space = "  -";
        StackTraceElement stackTraceElement0 = stackTrace[0];
        sb.append(String.format(ROOT_EXCEPTION_DESC, stackTraceElement0.getClassName(), stackTraceElement0.getMethodName(), stackTraceElement0.getLineNumber()));
        sb.append(String.format(ROOT_EXCEPTION_DESC_DETAIL, new Object[0]));
        int stackTraceLength = stackTrace.length;
        for (int i = 1; i < stackTraceLength; ++i) {
            StackTraceElement stackTraceElement12 = stackTrace[i];
            sb.append(space).append(stackTraceElement12.toString()).append("\n");
        }
        return sb.toString();
    }
}

