/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.flow.dto;

import cn.com.yusys.yusp.commons.util.StringUtils;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignQueryModel {
    protected static final Logger log = LoggerFactory.getLogger(FeignQueryModel.class);
    private static final JavaType COND_MAP_TYPE = TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Object.class);
    private String condition;
    private int page = 1;
    private int size = 10;
    private String sort;
    private String formattedOrderBy;
    @Deprecated
    private String dataAuth;

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void addCondition(String key, Object value) {
        ObjectMapper jsonObj = new ObjectMapper();
        try {
            String newCondition;
            Map conditionMap = (Map)jsonObj.readValue(this.condition, COND_MAP_TYPE);
            conditionMap.put(key, value);
            this.condition = newCondition = jsonObj.writeValueAsString((Object)conditionMap);
        }
        catch (Exception e) {
            log.error("Error in converting query condition to map format", (Throwable)e);
        }
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getSort() {
        String sort = this.formattedOrderBy;
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
        this.formatOrderBy(this.sort);
    }

    private void formatOrderBy(String orderBy) {
        if (orderBy != null && !"".equals(orderBy.trim())) {
            String[] orders;
            StringBuilder formattedOrderBy = new StringBuilder();
            String[] var4 = orders = orderBy.split(",");
            int var5 = orders.length;
            for (int var6 = 0; var6 < var5; ++var6) {
                String type;
                String order = var4[var6];
                String[] items = order.trim().split("\\s+|\\t+");
                if (items.length > 2) {
                    log.error("orderBy[" + orderBy + "] illegal field, no splicing");
                    return;
                }
                if (items.length >= 1 && ("and".equalsIgnoreCase((type = items[0]).trim()) || "or".equalsIgnoreCase(type.trim()))) {
                    log.error("orderBy[" + orderBy + "] illegal field, no splicing");
                    return;
                }
                if (items.length >= 2 && !"asc".equalsIgnoreCase(type = items[1]) && !"desc".equals(type)) {
                    log.error("orderBy[" + orderBy + "] illegal field, no splicing");
                    return;
                }
                formattedOrderBy.append(StringUtils.underLine((String)items[0]));
                if (items.length > 1) {
                    formattedOrderBy.append(" " + items[1]);
                }
                formattedOrderBy.append(",");
            }
            String newOrderBy = formattedOrderBy.toString();
            if (newOrderBy.endsWith(",")) {
                newOrderBy = newOrderBy.substring(0, newOrderBy.length() - 1);
            }
            this.formattedOrderBy = newOrderBy;
        }
    }

    @Deprecated
    public String getDataAuth() {
        return this.dataAuth;
    }

    @Deprecated
    public void setDataAuth(String dataAuth) {
        this.dataAuth = dataAuth;
    }
}

