/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.logic.lock;

import cn.com.yusys.yusp.commons.fee.common.ThreadLocalClean;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.CataLog;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.Logic;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.LogicParam;
import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.core.config.ApplicationProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@CataLog(nodeType=ActionNodeType.BIZ, value="tyzj/lock/zkfbss")
public class ZkLock
implements ThreadLocalClean {
    @Autowired
    private ApplicationProperties applicationProperties;
    private ThreadLocal<Map<String, InterProcessMutex>> mutexThreadLocal = ThreadLocal.withInitial(HashMap::new);
    private ThreadLocal<Map<String, Integer>> count = ThreadLocal.withInitial(HashMap::new);
    @Autowired(required=false)
    private CuratorFramework curatorFramework;

    @Logic(description="js")
    public void acquireDistributedLock(@LogicParam(description="jd", assignType="CONSTANT") String path, @LogicParam(description="cssj", assignType="CONSTANT") Long time) throws Throwable {
        if (this.curatorFramework == null) {
            throw Error.ZK_INIT_ERROR.expcetion();
        }
        if (time < 0L) {
            throw new IllegalArgumentException("Timeout must be greater than 0");
        }
        path = this.getLockPathPrefix() + path;
        InterProcessMutex mutex = this.mutexThreadLocal.get().get(path);
        if (mutex == null) {
            mutex = new InterProcessMutex(this.curatorFramework, path);
            this.mutexThreadLocal.get().put(path, mutex);
        }
        if (!mutex.acquire(time.longValue(), TimeUnit.SECONDS)) {
            throw Error.ZK_LOCK_TIMEOUT.expcetion();
        }
        this.count.get().put(path, this.count.get().get(path) == null ? 1 : this.count.get().get(path) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Logic(description="sfs")
    public void releaseDistributedLock(@LogicParam(description="jd", assignType="CONSTANT") String path) throws Exception {
        if (StringUtils.isEmpty((Object)path)) {
            throw new IllegalArgumentException("zk lock release parameter [path] cannot be empty");
        }
        path = this.getLockPathPrefix() + path;
        Integer c = this.count.get().get(path);
        c = c == null ? 0 : c;
        try {
            InterProcessMutex mutex = this.mutexThreadLocal.get().get(path);
            if (mutex != null && c > 0) {
                mutex.release();
                c = c - 1;
                this.count.get().put(path, c);
            }
        }
        finally {
            if (c < 1) {
                this.count.get().remove(path);
                ((ChildrenDeletable)this.curatorFramework.delete().guaranteed()).forPath(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws Exception {
        try {
            Map<String, InterProcessMutex> mutexMap = this.mutexThreadLocal.get();
            for (Map.Entry<String, InterProcessMutex> entry : mutexMap.entrySet()) {
                String key = entry.getKey();
                Integer c = this.count.get().get(key);
                c = c == null ? 0 : c;
                while (c > 0) {
                    String zkPath = key.substring(this.getLockPathPrefix().length());
                    this.releaseDistributedLock(zkPath);
                    Integer n = c;
                    Integer n2 = c = Integer.valueOf(c - 1);
                }
            }
        }
        finally {
            this.mutexThreadLocal.remove();
            this.count.remove();
        }
    }

    private String getLockPathPrefix() {
        return "/" + this.applicationProperties.getAppName() + "_feeLock/";
    }
}

