/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.logic.config;

import cn.com.yusys.yusp.bsp.workflow.IService;
import cn.com.yusys.yusp.commons.fee.logic.communicate.BSPService;
import cn.com.yusys.yusp.commons.fee.logic.communicate.RestTemplateHystrix;
import cn.com.yusys.yusp.commons.fee.logic.lock.ZkLock;
import cn.com.yusys.yusp.commons.fee.logic.zk.ZkCondition;
import cn.com.yusys.yusp.commons.fee.logic.zk.ZkWrapper;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LogicAutoConfiguration {
    @Bean
    public RestTemplateHystrix restTemplateHystrix() {
        return new RestTemplateHystrix();
    }

    @Bean
    public ZkLock zkLock() {
        return new ZkLock();
    }

    @Bean
    public ZkWrapper wrapperZK() {
        return new ZkWrapper();
    }

    @Bean(initMethod="start")
    @Conditional(value={ZkCondition.class})
    public CuratorFramework curatorFramework() {
        return CuratorFrameworkFactory.newClient((String)this.wrapperZK().getConnectString(), (int)this.wrapperZK().getSessionTimeoutMs(), (int)this.wrapperZK().getConnectionTimeoutMs(), (RetryPolicy)new RetryNTimes(this.wrapperZK().getRetryCount(), this.wrapperZK().getElapsedTimeMs()));
    }

    @ConditionalOnClass(value={IService.class})
    @Configuration
    class FeeBspAutoConfiguration {
        FeeBspAutoConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public IService iService() {
            return new BSPService();
        }
    }
}

