/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.logic.communicate;

import cn.com.yusys.yusp.commons.fee.common.component.Flow;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import cn.com.yusys.yusp.commons.fee.common.util.FlowUtil;
import cn.com.yusys.yusp.commons.fee.common.util.SpringContextHolder;
import cn.com.yusys.yusp.commons.fee.logic.communicate.CommunicatLogic;
import cn.com.yusys.yusp.commons.module.adapter.query.QueryModel;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class RestTemplateHystrix {
    private static final Logger logger = LoggerFactory.getLogger(RestTemplateHystrix.class);
    private static final String MARK = "${";
    private static final String SLASH = "/{";

    public String getError() {
        return "over time";
    }

    @HystrixCommand(fallbackMethod="getError")
    public Object execute(String api, String responseClassName, Object body) {
        try {
            if (body instanceof QueryModel) {
                body = CommunicatLogic.copyAndSetQueryModel((QueryModel)body);
            }
            Flow currentFlow = FlowUtil.getSAGACurrentFlow();
            RestTemplate restTemplate = null;
            restTemplate = currentFlow != null ? (RestTemplate)SpringContextHolder.getBean((String)"omegaRestTemplate") : (RestTemplate)SpringContextHolder.getBean((String)"feeresttemplate");
            if (api.startsWith("1")) {
                api = "http://" + api;
            }
            if (api.contains(MARK)) {
                api = CommunicatLogic.getYmlConfig(api);
            }
            if (api.contains(SLASH)) {
                api = CommunicatLogic.getValueFromContext(api);
            }
            Object responseDate = restTemplate.postForEntity(api, body, ClassUtil.strToClass((String)responseClassName), new Object[0]).getBody();
            return responseDate;
        }
        catch (Exception ex) {
            logger.error("[{}] request failed, {}", (Object)api, (Object)ex.getMessage());
            throw Error.COMMUNICATE_MS_FAILED.expcetion(ex.getMessage());
        }
    }
}

