/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.logic;

import cn.com.yusys.yusp.commons.fee.common.annotation.ide.CataLog;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.Logic;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.LogicParam;
import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.springframework.util.StringUtils;

@CataLog(nodeType=ActionNodeType.BIZ, value="tyzj/time")
public class DateLogic {
    @Logic(description="dqsj")
    public static String getFormatDate(@LogicParam(description="sjgs", assignType="CONSTANT") String format) {
        DateTimeFormatter formatter = StringUtils.isEmpty((Object)format) ? DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.CHINESE) : DateTimeFormatter.ofPattern(format, Locale.CHINESE);
        LocalDateTime now = LocalDateTime.now();
        return now.format(formatter);
    }

    @Logic(description="zdpcsj")
    public static String plusDate(@LogicParam(description="zdsj") String time, @LogicParam(description="sjgs", assignType="CONSTANT") String format, @LogicParam(description="sjpc", assignType="CONSTANT") String plus) {
        DateTimeFormatter formatter = StringUtils.isEmpty((Object)format) ? DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.CHINESE) : DateTimeFormatter.ofPattern(format, Locale.CHINESE);
        LocalDateTime datetime = StringUtils.isEmpty((Object)time) ? LocalDateTime.now() : LocalDateTime.parse(time, formatter);
        LocalDateTime newDatetime = datetime;
        if (!StringUtils.isEmpty((Object)plus)) {
            String[] plusTime;
            for (String pt : plusTime = plus.split(",")) {
                String plusValueStr = pt.substring(0, pt.length() - 1);
                long plusValue = Long.parseLong(plusValueStr);
                if (pt.endsWith("y")) {
                    newDatetime = newDatetime.plusYears(plusValue);
                    continue;
                }
                if (pt.endsWith("M")) {
                    newDatetime = newDatetime.plusMonths(plusValue);
                    continue;
                }
                if (pt.endsWith("d")) {
                    newDatetime = newDatetime.plusDays(plusValue);
                    continue;
                }
                if (pt.endsWith("H")) {
                    newDatetime = newDatetime.plusHours(plusValue);
                    continue;
                }
                if (pt.endsWith("m")) {
                    newDatetime = newDatetime.plusMinutes(plusValue);
                    continue;
                }
                if (!pt.endsWith("s")) continue;
                newDatetime = newDatetime.plusSeconds(plusValue);
            }
        }
        return newDatetime.format(formatter);
    }

    @Logic(description="sjgszh")
    public static String formatConvert(@LogicParam(description="zdsj") String time, @LogicParam(description="dqgs", assignType="CONSTANT") String curFormat, @LogicParam(description="xgs", assignType="CONSTANT") String newFormat) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(curFormat, Locale.CHINESE);
        DateTimeFormatter newFormatter = DateTimeFormatter.ofPattern(newFormat, Locale.CHINESE);
        LocalDateTime datetime = LocalDateTime.parse(time, formatter);
        return datetime.format(newFormatter);
    }
}

