/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.logic.zookeeper;

import cn.com.yusys.yusp.commons.fee.common.ThreadLocalClean;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.CataLog;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.Logic;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.LogicParam;
import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.core.config.ApplicationProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@CataLog(nodeType=ActionNodeType.BIZ, value="\u901a\u7528\u7ec4\u4ef6/\u9501/zk\u5206\u5e03\u5f0f\u9501")
public class ZkLock
implements ThreadLocalClean {
    @Autowired
    private ApplicationProperties applicationProperties;
    private ThreadLocal<Map<String, InterProcessMutex>> mutexThreadLocal = ThreadLocal.withInitial(HashMap::new);
    private ThreadLocal<Map<String, Integer>> count = ThreadLocal.withInitial(HashMap::new);
    @Autowired(required=false)
    private CuratorFramework curatorFramework;

    @Logic(description="\u52a0\u9501")
    public void acquireDistributedLock(@LogicParam(description="\u8282\u70b9", assignType="CONSTANT") String path, @LogicParam(description="\u8d85\u65f6\u65f6\u95f4", assignType="CONSTANT") Long time) throws Throwable {
        if (this.curatorFramework == null) {
            throw Error.ZK_INIT_ERROR.expcetion();
        }
        if (time < 0L) {
            throw new IllegalArgumentException("\u8d85\u65f6\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e0");
        }
        path = this.getLockPathPrefix() + path;
        InterProcessMutex mutex = this.mutexThreadLocal.get().get(path);
        if (mutex == null) {
            mutex = new InterProcessMutex(this.curatorFramework, path);
            this.mutexThreadLocal.get().put(path, mutex);
        }
        if (!mutex.acquire(time.longValue(), TimeUnit.SECONDS)) {
            throw Error.ZK_LOCK_TIMEOUT.expcetion();
        }
        this.count.get().put(path, this.count.get().get(path) == null ? 1 : this.count.get().get(path) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Logic(description="\u91ca\u653e\u9501")
    public void releaseDistributedLock(@LogicParam(description="\u8282\u70b9", assignType="CONSTANT") String path) throws Throwable {
        if (StringUtils.isEmpty((Object)path)) {
            throw new IllegalArgumentException("zk\u9501\u91ca\u653e\u53c2\u6570path\u4e0d\u80fd\u4e3a\u7a7a");
        }
        path = this.getLockPathPrefix() + path;
        Integer c = this.count.get().get(path);
        c = c == null ? 0 : c;
        try {
            InterProcessMutex mutex = this.mutexThreadLocal.get().get(path);
            if (mutex != null && c > 0) {
                mutex.release();
                c = c - 1;
                this.count.get().put(path, c);
            }
        }
        finally {
            if (c < 1) {
                this.count.get().remove(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws Throwable {
        try {
            Map<String, InterProcessMutex> mutexMap = this.mutexThreadLocal.get();
            for (Map.Entry<String, InterProcessMutex> entry : mutexMap.entrySet()) {
                String key = entry.getKey();
                Integer c = this.count.get().get(key);
                c = c == null ? 0 : c;
                while (c > 0) {
                    String zkPath = key.substring(this.getLockPathPrefix().length());
                    this.releaseDistributedLock(zkPath);
                    Integer n = c;
                    Integer n2 = c = Integer.valueOf(c - 1);
                }
            }
        }
        finally {
            this.mutexThreadLocal.remove();
            this.count.remove();
        }
    }

    private String getLockPathPrefix() {
        return "/" + this.applicationProperties.getAppName() + "/feeLock/";
    }
}

