/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.logic.communicate;

import cn.com.yusys.yusp.bsp.communication.BspTemplate;
import cn.com.yusys.yusp.bsp.workflow.comm.out.CommType;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.CataLog;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.Logic;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.LogicParam;
import cn.com.yusys.yusp.commons.fee.common.component.Flow;
import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import cn.com.yusys.yusp.commons.fee.common.util.FlowUtil;
import cn.com.yusys.yusp.commons.fee.common.util.MessageFormat;
import cn.com.yusys.yusp.commons.fee.common.util.SpringContextHolder;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.client.RestTemplate;

@CataLog(nodeType=ActionNodeType.COMMUNICAT, value="\u901a\u7528\u7ec4\u4ef6/\u901a\u8baf\u5de5\u5177")
public class CommunicatLogic {
    private static final Logger logger = LoggerFactory.getLogger(CommunicatLogic.class);

    public static <T> T bspGet(@LogicParam(description="\u9002\u914d\u5668\u540d\u79f0", assignType="CONSTANT") String adapterName, @LogicParam(description="\u4ea4\u6613\u4ee3\u7801", assignType="CONSTANT") String tradeCode, @LogicParam(description="\u8bf7\u6c42\u5bf9\u8c61") Object paramObj, @LogicParam(description="API", assignType="CONSTANT") String api, @LogicParam(description="\u54cd\u5e94class", assignType="CONSTANT") Class<T> rtnClazz) {
        return CommunicatLogic.bspAccess(adapterName, tradeCode, paramObj, api, rtnClazz, HttpMethod.GET);
    }

    @Logic(description="BSP\u901a\u8baf\u63a5\u51fa", async=true)
    public static <T> T bspPost(@LogicParam(description="\u9002\u914d\u5668\u540d\u79f0", assignType="CONSTANT") String adapterName, @LogicParam(description="\u4ea4\u6613\u4ee3\u7801", assignType="CONSTANT") String tradeCode, @LogicParam(description="\u8bf7\u6c42\u5bf9\u8c61") Object paramObj, @LogicParam(description="API", assignType="CONSTANT") String api, @LogicParam(description="\u54cd\u5e94class", assignType="CONSTANT") Class<T> rtnClazz) {
        return CommunicatLogic.bspAccess(adapterName, tradeCode, paramObj, api, rtnClazz, HttpMethod.POST);
    }

    private static <T> T bspAccess(String adapterName, String tradeCode, Object paramObj, String api, Class<T> rtnClazz, HttpMethod httpMethod) {
        logger.info("\u9002\u914d\u5668\u540d\u79f0[{}],\u4ea4\u6613\u4ee3\u7801[{}], \u8bf7\u6c42\u5bf9\u8c61[{}]", new Object[]{adapterName, tradeCode, paramObj});
        HashMap<String, String> commPara = new HashMap<String, String>();
        commPara.put(CommType.HTTPCOMM_URI.getKey(), api);
        commPara.put(CommType.HTTPCOMM_METHOD.getKey(), httpMethod.name());
        commPara.put(CommType.HTTPCOMM_CONTENTTYPE.getKey(), "application/json");
        try {
            Object result = BspTemplate.exchange((String)adapterName, (String)tradeCode, (Object)paramObj, commPara, rtnClazz);
            if (logger.isDebugEnabled()) {
                logger.debug("result:{}", result);
            }
            return (T)result;
        }
        catch (Exception ex) {
            logger.error("BSP\u8bf7\u6c42\u5931\u8d25", (Throwable)ex);
            throw Error.COMMUNICATE_BSP_FAILED.expcetion(ex.getMessage());
        }
    }

    @Logic(description="\u5fae\u670d\u52a1Get\u63a5\u51fa", async=true)
    public static Object restCallGet(@LogicParam(description="API", assignType="CONSTANT") String api, @LogicParam(description="\u54cd\u5e94\u7c7b\u540d\u79f0", assignType="CONSTANT") String responseClassName, @LogicParam(description="\u53c2\u6570\u5b9e\u4f53\u7c7b") Object paramObj) {
        return CommunicatLogic.restCallGet2(api, responseClassName, paramObj);
    }

    private static Object restCallGet2(String api, String responseClassName, Object paramObj) {
        try {
            Flow currentFlow = FlowUtil.getSAGACurrentFlow();
            RestTemplate restTemplate = null;
            restTemplate = currentFlow != null ? (RestTemplate)SpringContextHolder.getBean((String)"omegaRestTemplate") : (RestTemplate)SpringContextHolder.getBean((String)"restTemplate");
            api = MessageFormat.queryLine((String)api, (Object)paramObj);
            Object responseDate = restTemplate.getForEntity(api, ClassUtil.strToClass((String)responseClassName), new Object[0]).getBody();
            if (logger.isDebugEnabled()) {
                logger.debug("API:{}", (Object)api);
                logger.debug("\u54cd\u5e94\u6570\u636e:{}", responseDate);
            }
            return responseDate;
        }
        catch (Exception ex) {
            logger.error("[{}]\u8bf7\u6c42\u5931\u8d25", (Object)api);
            throw Error.COMMUNICATE_MS_FAILED.expcetion(ex.getMessage());
        }
    }

    public static <T> T restCallGet(@LogicParam(description="API", assignType="CONSTANT") String api, @LogicParam(description="\u54cd\u5e94\u7c7b") Class<T> responseClass, @LogicParam(description="\u53c2\u6570\u5b9e\u4f53\u7c7b") Object paramObj) {
        try {
            RestTemplate restTemplate = (RestTemplate)SpringContextHolder.getBean(RestTemplate.class);
            api = MessageFormat.queryLine((String)api, (Object)paramObj);
            Object t = restTemplate.getForEntity(api, responseClass, new Object[0]).getBody();
            if (logger.isDebugEnabled()) {
                logger.debug("API:{}", (Object)api);
                logger.debug("\u54cd\u5e94\u6570\u636e:{}", t);
            }
            return (T)t;
        }
        catch (Exception ex) {
            logger.error("[{}]\u8bf7\u6c42\u5931\u8d25,{}", (Object)api, (Object)ex.getMessage());
            throw Error.COMMUNICATE_MS_FAILED.expcetion();
        }
    }

    @Logic(description="\u5fae\u670d\u52a1Post\u63a5\u51fa", async=true)
    public static Object restCallPost(@LogicParam(description="API", assignType="CONSTANT") String api, @LogicParam(description="\u54cd\u5e94\u7c7b\u540d\u79f0", assignType="CONSTANT") String responseClassName, @LogicParam(description="\u6d88\u606f\u4f53") Object body) {
        return CommunicatLogic.restCallPost2(api, responseClassName, body);
    }

    private static Object restCallPost2(String api, String responseClassName, Object body) {
        try {
            Flow currentFlow = FlowUtil.getSAGACurrentFlow();
            RestTemplate restTemplate = null;
            restTemplate = currentFlow != null ? (RestTemplate)SpringContextHolder.getBean((String)"omegaRestTemplate") : (RestTemplate)SpringContextHolder.getBean((String)"restTemplate");
            Object responseDate = restTemplate.postForEntity(api, body, ClassUtil.strToClass((String)responseClassName), new Object[0]).getBody();
            if (logger.isDebugEnabled()) {
                logger.debug("API:{}", (Object)api);
                logger.debug("\u54cd\u5e94\u6570\u636e:{}", responseDate);
            }
            return responseDate;
        }
        catch (Exception ex) {
            logger.error("[{}]\u8bf7\u6c42\u5931\u8d25,{}", (Object)api, (Object)ex.getMessage());
            throw Error.COMMUNICATE_MS_FAILED.expcetion(ex.getMessage());
        }
    }
}

