/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.logic.collection;

import cn.com.yusys.yusp.commons.fee.common.annotation.ide.CataLog;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.Logic;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.LogicParam;
import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CataLog(nodeType=ActionNodeType.BIZ, value="\u901a\u7528\u7ec4\u4ef6/\u96c6\u5408/\u6570\u7ec4")
public class ArrayLogic {
    private static final Logger logger = LoggerFactory.getLogger(ArrayLogic.class);

    @Logic(description="newArray")
    public static Object[] newArray(@LogicParam(description="\u6570\u7ec4\u5927\u5c0f") int n) {
        if (n < 1) {
            logger.error("\u6570\u7ec4\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e1,\u6570\u7ec4\u5927\u5c0f\u4e3a{}", (Object)n);
            throw new IllegalArgumentException("\u6570\u7ec4\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        return new Object[n];
    }

    @Logic(description="addAt")
    public static void addAt(@LogicParam(description="\u4e0a\u4e0b\u6587\u6570\u7ec4") Object[] array, @LogicParam(description="\u6570\u7ec4\u7d22\u5f15") int index, @LogicParam(description="\u503c") Object value) {
        ArrayLogic.check(array, index);
        array[index] = value;
    }

    @Logic(description="getByIndex")
    public static Object getByIndex(@LogicParam(description="\u4e0a\u4e0b\u6587\u6570\u7ec4") Object[] array, @LogicParam(description="\u6570\u7ec4\u7d22\u5f15") int index) {
        ArrayLogic.check(array, index);
        return array[index];
    }

    @Logic(description="length")
    public static int length(@LogicParam(description="\u4e0a\u4e0b\u6587\u6570\u7ec4") Object[] array) {
        if (array == null || array.length < 1) {
            throw new IllegalArgumentException("\u7a7a\u7684\u6570\u7ec4");
        }
        return array.length;
    }

    private static void check(Object[] array, int index) {
        if (array == null || array.length < 1) {
            throw new IllegalArgumentException("\u7a7a\u7684\u6570\u7ec4");
        }
        if (index < 0 || index > array.length) {
            logger.error("\u6570\u7ec4\u8fb9\u754c\u6ea2\u51fa,index={},array.length={}", (Object)index, (Object)array.length);
            throw new IllegalArgumentException("\u6570\u7ec4\u8fb9\u754c\u6ea2\u51fa");
        }
    }
}

