/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.logic;

import cn.com.yusys.yusp.commons.fee.common.annotation.ide.CataLog;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.Logic;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.LogicParam;
import cn.com.yusys.yusp.commons.fee.common.component.Context;
import cn.com.yusys.yusp.commons.fee.common.component.ContextHolder;
import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import cn.com.yusys.yusp.commons.fee.common.enums.TransitionType;
import cn.com.yusys.yusp.commons.fee.common.exception.Error;
import cn.com.yusys.yusp.commons.fee.common.logic.DistributeLock;
import cn.com.yusys.yusp.commons.fee.common.util.LocalMark;
import cn.com.yusys.yusp.commons.fee.core.component.transition.AnalyzeFactory;
import cn.com.yusys.yusp.commons.fee.db.DBAccessor;
import java.util.List;
import org.apache.ibatis.parsing.GenericTokenParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@CataLog(nodeType=ActionNodeType.BIZ, value="\u901a\u7528\u7ec4\u4ef6/\u5e42\u7b49")
public class IdempotentLogic {
    private static final Logger logger = LoggerFactory.getLogger(IdempotentLogic.class);
    @Autowired
    private GenericTokenParser genericTokenParser;
    @Autowired
    private DBAccessor dbAccessor;
    @Autowired
    private DistributeLock distributeLock;

    @Logic(description="\u6761\u4ef6\u5e42\u7b49")
    public void addIdempotent(@LogicParam(description="\u552f\u4e00id") String id, @LogicParam(description="\u67e5\u8be2sql", assignType="CONSTANT") String querySql, @LogicParam(description="\u67e5\u8be2\u7ed3\u679ckey", assignType="CONSTANT") String resultKey, @LogicParam(description="\u5e42\u7b49\u6761\u4ef6", assignType="CONSTANT") String condition) {
        this.idempotent(id, querySql, resultKey, condition);
    }

    private void idempotent(String id, String querySql, String resultKey, String condition) {
        try {
            this.distributeLock.lock(id, 30L, 0, 0L);
            String sql = this.genericTokenParser.parse(querySql);
            List dbResult = this.dbAccessor.query(sql);
            boolean stop = false;
            if (dbResult != null && !dbResult.isEmpty()) {
                if (!StringUtils.isEmpty((Object)resultKey) && !StringUtils.isEmpty((Object)condition)) {
                    Context context = ContextHolder.getContext();
                    context.putParam(resultKey, (Object)dbResult);
                    stop = AnalyzeFactory.getAnalyze((TransitionType)TransitionType.NORMAL).match(condition, context, null);
                } else {
                    stop = true;
                }
            }
            if (stop) {
                LocalMark.setInterrupt((Boolean)true);
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw Error.IDEMPOTENT_ERROR.expcetion();
        }
        finally {
            this.distributeLock.releaseLock(id);
        }
    }

    @Logic(description="\u5e42\u7b49")
    public void addIdempotent(@LogicParam(description="\u552f\u4e00id") String id, @LogicParam(description="\u67e5\u8be2sql", assignType="CONSTANT") String querySql) {
        this.idempotent(id, querySql, null, null);
    }
}

