/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.logic;

import cn.com.yusys.yusp.commons.fee.common.annotation.ide.CataLog;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.Logic;
import cn.com.yusys.yusp.commons.fee.common.annotation.ide.LogicParam;
import cn.com.yusys.yusp.commons.fee.common.enums.ActionNodeType;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.util.StringUtils;

@CataLog(nodeType=ActionNodeType.BIZ, value="\u901a\u7528\u7ec4\u4ef6/\u65f6\u95f4")
public class DateLogic {
    @Logic(description="\u5f53\u524d\u65f6\u95f4")
    public static String getFormatDate(@LogicParam(description="\u65f6\u95f4\u683c\u5f0f", assignType="CONSTANT") String format) {
        DateTimeFormatter formatter = StringUtils.isEmpty((Object)format) ? DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss") : DateTimeFormatter.ofPattern(format);
        LocalDateTime now = LocalDateTime.now();
        return now.format(formatter);
    }

    @Logic(description="\u6307\u5b9a\u504f\u5dee\u65f6\u95f4")
    public static String plusDate(@LogicParam(description="\u6307\u5b9a\u65f6\u95f4") String time, @LogicParam(description="\u65f6\u95f4\u683c\u5f0f", assignType="CONSTANT") String format, @LogicParam(description="\u65f6\u95f4\u504f\u5dee", assignType="CONSTANT") String plus) {
        DateTimeFormatter formatter = StringUtils.isEmpty((Object)format) ? DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss") : DateTimeFormatter.ofPattern(format);
        LocalDateTime datetime = StringUtils.isEmpty((Object)time) ? LocalDateTime.now() : LocalDateTime.parse(time, formatter);
        LocalDateTime newDatetime = datetime;
        if (!StringUtils.isEmpty((Object)plus)) {
            String[] plusTime;
            for (String pt : plusTime = plus.split(",")) {
                String plusValueStr = pt.substring(0, pt.length() - 1);
                long plusValue = Long.parseLong(plusValueStr);
                if (pt.endsWith("y")) {
                    newDatetime = newDatetime.plusYears(plusValue);
                    continue;
                }
                if (pt.endsWith("M")) {
                    newDatetime = newDatetime.plusMonths(plusValue);
                    continue;
                }
                if (pt.endsWith("d")) {
                    newDatetime = newDatetime.plusDays(plusValue);
                    continue;
                }
                if (pt.endsWith("H")) {
                    newDatetime = newDatetime.plusHours(plusValue);
                    continue;
                }
                if (pt.endsWith("m")) {
                    newDatetime = newDatetime.plusMinutes(plusValue);
                    continue;
                }
                if (!pt.endsWith("s")) continue;
                newDatetime = newDatetime.plusSeconds(plusValue);
            }
        }
        return newDatetime.format(formatter);
    }

    @Logic(description="\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362")
    public static String formatConvert(@LogicParam(description="\u9700\u8981\u88ab\u8f6c\u6362\u683c\u5f0f\u7684\u65f6\u95f4") String time, @LogicParam(description="\u5f53\u524d\u683c\u5f0f", assignType="CONSTANT") String curFormat, @LogicParam(description="\u65b0\u683c\u5f0f", assignType="CONSTANT") String newFormat) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(curFormat);
        DateTimeFormatter newFormatter = DateTimeFormatter.ofPattern(newFormat);
        LocalDateTime datetime = LocalDateTime.parse(time, formatter);
        return datetime.format(newFormatter);
    }
}

