/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.db;

import cn.com.yusys.yusp.commons.fee.common.util.SpringContextHolder;
import cn.com.yusys.yusp.commons.fee.db.DBUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.SqlSessionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class DBAccessor {
    private static final Logger logger = LoggerFactory.getLogger(DBAccessor.class);
    private static int accessCount = 0;
    private static long totalCostTime = 0L;
    @Autowired
    private SqlSessionTemplate sqlSessionTemplate;

    public String detectDbType(Connection connection) {
        block11: {
            String name;
            block10: {
                block9: {
                    block8: {
                        DatabaseMetaData metaData = connection.getMetaData();
                        name = metaData.getDatabaseProductName();
                        logger.info("\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + name);
                        if (!name.toUpperCase().contains("MYSQL")) break block8;
                        String string = "MySQL";
                        return string;
                    }
                    if (!name.toUpperCase().contains("ORACLE")) break block9;
                    String string = "ORACLE";
                    return string;
                }
                if (!name.contains("Microsoft")) break block10;
                String string = "MSSQL";
                return string;
            }
            if (!name.toUpperCase().contains("DB2")) break block11;
            String string = "DB2";
            return string;
        }
        try {
            String string = null;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Connection getConnection() throws SQLException {
        DataSource datasource = (DataSource)SpringContextHolder.getBean((String)"dataSource");
        Connection connection = DataSourceUtils.getConnection((DataSource)datasource);
        return connection;
    }

    public SqlSession getSqlSession() throws SQLException {
        SqlSession sqlSession = SqlSessionUtils.getSqlSession((SqlSessionFactory)this.sqlSessionTemplate.getSqlSessionFactory());
        return sqlSession;
    }

    public void close(SqlSession sqlSession) {
        SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)this.sqlSessionTemplate.getSqlSessionFactory());
    }

    public void close(Connection con) {
        DataSource datasource = (DataSource)SpringContextHolder.getBean((String)"dataSource");
        DataSourceUtils.releaseConnection((Connection)con, (DataSource)datasource);
    }

    public boolean execute(String sql) throws Exception {
        logger.info("sql:" + sql);
        long t = System.currentTimeMillis();
        this.recordStartTime(t, sql);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            int num = stmt.executeUpdate(sql);
            this.recordCostTime(t, sql);
            if (num > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql:" + sql, (Throwable)e);
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public boolean execute(String sql, Map<String, Object> paramMap) throws Exception {
        long t = System.currentTimeMillis();
        this.recordStartTime(t, sql);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            stmt = DBUtil.createPreparedStatement(this.detectDbType(con), con, sql, paramMap);
            boolean res = stmt.execute();
            this.recordCostTime(t, sql);
            boolean bl = res;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql=" + stmt + " ,input:" + paramMap, (Throwable)e);
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public int executeInUpd(String sql, Map<String, Object> paramMap) throws Exception {
        long t = System.currentTimeMillis();
        this.recordStartTime(t, sql);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            stmt = DBUtil.createPreparedStatement(this.detectDbType(con), con, sql, paramMap);
            int num = stmt.executeUpdate();
            this.recordCostTime(t, sql);
            int n = num;
            return n;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql=" + stmt + " ,input:" + paramMap, (Throwable)e);
            throw e;
        }
        finally {
            this.close(con);
            stmt.close();
        }
    }

    public int executeInUpd(String sql, Object object) throws Exception {
        long t = System.currentTimeMillis();
        this.recordStartTime(t, sql);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            stmt = DBUtil.createPreparedStatement(this.detectDbType(con), con, sql, object);
            int num = stmt.executeUpdate();
            this.recordCostTime(t, sql);
            int n = num;
            return n;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql=" + stmt + " ,input:" + object, (Throwable)e);
            throw e;
        }
        finally {
            this.close(con);
            stmt.close();
        }
    }

    public boolean execute(String sql, Object ... args) throws Exception {
        long t = System.currentTimeMillis();
        this.recordStartTime(t, sql);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = DBUtil.createPreparedStatement(this.detectDbType(con), con, sql, args);
            boolean res = stmt.execute();
            this.recordCostTime(t, sql);
            boolean bl = res;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql:" + stmt + " ,input:" + Arrays.toString(args), (Throwable)e);
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public int[] batchExec(List<String> sql, List<Map<String, Object>> paramList) throws Exception {
        long t = System.currentTimeMillis();
        int size = sql.size();
        if (sql.size() != paramList.size()) {
            throw new SQLException("sql\u8bed\u53e5\u4e2a\u6570\u548c\u53c2\u6570\u5217\u8868\u4e2a\u6570\u4e0d\u4e00\u81f4");
        }
        String sqlMsg = Arrays.toString(sql.toArray(new String[0]));
        this.recordStartTime(t, sqlMsg);
        Connection con = null;
        Statement stmt = null;
        int[] resArray = new int[size];
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            for (int i = 0; i < size; ++i) {
                Map<String, Object> paramMap = paramList.get(i);
                stmt = DBUtil.createPreparedStatement(this.detectDbType(con), con, sql.get(i), paramMap);
                stmt.execute();
                resArray[i] = stmt.getUpdateCount();
                stmt.close();
            }
            this.recordCostTime(t, sqlMsg);
            int[] i = resArray;
            return i;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql:" + sqlMsg + " ,input:" + paramList, (Throwable)e);
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public int[] batchExec(List<String> sql) throws Exception {
        long t = System.currentTimeMillis();
        String sqlMsg = Arrays.toString(sql.toArray(new String[0]));
        this.recordStartTime(t, sqlMsg);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = con.createStatement();
            int size = sql.size();
            for (int i = 0; i < size; ++i) {
                stmt.addBatch(sql.get(i));
            }
            int[] res = stmt.executeBatch();
            this.recordCostTime(t, sqlMsg);
            int[] nArray = res;
            return nArray;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql:" + sqlMsg, (Throwable)e);
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public int[] batchExecInTransaction(List<String> sql, List<Map<String, Object>> paramList) throws Exception {
        long t = System.currentTimeMillis();
        int size = sql.size();
        if (sql.size() != paramList.size()) {
            throw new SQLException("sql\u8bed\u53e5\u4e2a\u6570\u548c\u53c2\u6570\u5217\u8868\u4e2a\u6570\u4e0d\u4e00\u81f4");
        }
        String sqlMsg = Arrays.toString(sql.toArray(new String[0]));
        this.recordStartTime(t, sqlMsg);
        Connection con = null;
        int[] resArray = new int[size];
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            for (int i = 0; i < size; ++i) {
                Map<String, Object> paramMap = paramList.get(i);
                logger.debug("sql:" + sql.get(i));
                PreparedStatement stmt = DBUtil.createPreparedStatement(this.detectDbType(con), con, sql.get(i), paramMap);
                stmt.execute();
                resArray[i] = stmt.getUpdateCount();
                stmt.close();
            }
            con.commit();
            this.recordCostTime(t, sqlMsg);
            int[] i = resArray;
            return i;
        }
        catch (Exception e) {
            con.rollback();
            String input = "";
            if (sql != null) {
                input = "" + paramList.toString();
            }
            logger.error(e.getMessage() + " ,sql:" + sqlMsg + " ,input:" + input, (Throwable)e);
            throw e;
        }
        finally {
            if (con != null) {
                try {
                    con.setAutoCommit(true);
                    con.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public int[] batchExecInTransaction(List<String> sql) throws Exception {
        long t = System.currentTimeMillis();
        String sqlMsg = Arrays.toString(sql.toArray(new String[0]));
        this.recordStartTime(t, sqlMsg);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(false);
            stmt = con.createStatement();
            int size22 = sql.size();
            for (int i = 0; i < size22; ++i) {
                stmt.addBatch(sql.get(i));
            }
            int[] res = stmt.executeBatch();
            con.commit();
            this.recordCostTime(t, sqlMsg);
            int[] size22 = res;
            return size22;
        }
        catch (Exception e) {
            try {
                con.rollback();
            }
            catch (SQLException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            logger.error(e.getMessage() + " ,sql:" + sqlMsg, (Throwable)e);
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.setAutoCommit(true);
                    con.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public int update(String sql) throws Exception {
        long t = System.currentTimeMillis();
        this.recordStartTime(t, sql);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            stmt = con.createStatement();
            int res = stmt.executeUpdate(sql);
            this.recordCostTime(t, sql);
            int n = res;
            return n;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql:" + sql, (Throwable)e);
            throw e;
        }
        finally {
            this.close(con);
            stmt.close();
        }
    }

    public int update(String sql, Map<String, Object> paramMap) throws Exception {
        long t = System.currentTimeMillis();
        this.recordStartTime(t, sql);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = DBUtil.createPreparedStatement(this.detectDbType(con), con, sql, paramMap);
            int res = stmt.executeUpdate();
            this.recordCostTime(t, sql);
            int n = res;
            return n;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql:" + sql + " ,input:" + paramMap, (Throwable)e);
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public int update(String sql, Object ... args) throws Exception {
        long t = System.currentTimeMillis();
        this.recordStartTime(t, sql);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = DBUtil.createPreparedStatement(this.detectDbType(con), con, sql, args);
            int res = stmt.executeUpdate();
            this.recordCostTime(t, sql);
            int n = res;
            return n;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql:" + sql + " ,input:" + Arrays.toString(args), (Throwable)e);
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public List<Map<String, Object>> query(String sql, Map<String, Class<?>> resTypeMap) throws Exception {
        long t = System.currentTimeMillis();
        this.recordStartTime(t, sql);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            String dbtype = this.detectDbType(con);
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            List<Map<String, Object>> res = resTypeMap == null || resTypeMap.size() == 0 ? DBUtil.convertResultSetToMap(rs, dbtype) : DBUtil.convertResultSetToMap(rs, resTypeMap, dbtype);
            this.recordCostTime(t, sql);
            List<Map<String, Object>> list = res;
            return list;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql:" + sql, (Throwable)e);
            throw e;
        }
        finally {
            this.close(con);
            stmt.close();
        }
    }

    public List<Map<String, Object>> query(String sql, Object object) throws Exception {
        long t = System.currentTimeMillis();
        this.recordStartTime(t, sql);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            String dbtype = this.detectDbType(con);
            stmt = DBUtil.createPreparedStatement(this.detectDbType(con), con, sql, object);
            ResultSet rs = stmt.executeQuery();
            List<Map<String, Object>> res = DBUtil.convertResultSetToMap(rs, dbtype);
            this.recordCostTime(t, sql);
            List<Map<String, Object>> list = res;
            return list;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql:" + sql, (Throwable)e);
            throw e;
        }
        finally {
            this.close(con);
            stmt.close();
        }
    }

    public List<Map<String, Object>> query(String sql) throws Exception {
        List<Map<String, Object>> res = this.query(sql, null);
        return res;
    }

    public List<Map<String, Object>> query(String sql, Map<String, Object> paramMap, Map<String, Class<?>> resTypeMap) throws Exception {
        long t = System.currentTimeMillis();
        this.recordStartTime(t, sql);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            stmt = DBUtil.createPreparedStatement(this.detectDbType(con), con, sql, paramMap);
            ResultSet rs = stmt.executeQuery();
            List<Map<String, Object>> res = resTypeMap == null || resTypeMap.size() == 0 ? DBUtil.convertResultSetToMap(rs, this.detectDbType(con)) : DBUtil.convertResultSetToMap(rs, resTypeMap, this.detectDbType(con));
            this.recordCostTime(t, sql);
            List<Map<String, Object>> list = res;
            return list;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql:" + sql + " ,input:" + paramMap, (Throwable)e);
            throw e;
        }
        finally {
            this.close(con);
            stmt.close();
        }
    }

    public List<Map<String, Object>> query(String sql, Object[] args, Map<String, Class<?>> resTypeMap) throws Exception {
        long t = System.currentTimeMillis();
        this.recordStartTime(t, sql);
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = this.getConnection();
            stmt = DBUtil.createPreparedStatement(this.detectDbType(con), con, sql, args);
            ResultSet rs = stmt.executeQuery();
            List<Map<String, Object>> res = resTypeMap == null || resTypeMap.size() == 0 ? DBUtil.convertResultSetToMap(rs, this.detectDbType(con)) : DBUtil.convertResultSetToMap(rs, resTypeMap, this.detectDbType(con));
            this.recordCostTime(t, sql);
            return res;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql:" + sql + " ,input:" + Arrays.toString(args), (Throwable)e);
            throw e;
        }
    }

    public <T> List<T> queryForBean(String sql, Class<T> beanType) throws Exception {
        long t = System.currentTimeMillis();
        this.recordStartTime(t, sql);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            List<T> res = beanType == null ? DBUtil.convertResultSetToBean(rs, beanType, this.detectDbType(con)) : DBUtil.convertResultSetToBean(rs, beanType, this.detectDbType(con));
            this.recordCostTime(t, sql);
            List<T> list = res;
            return list;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql:" + sql, (Throwable)e);
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public <T> List<T> queryForBean(String sql, Map<String, Object> paramMap, Class<T> beanType) throws Exception {
        long t = System.currentTimeMillis();
        this.recordStartTime(t, sql);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = DBUtil.createPreparedStatement(this.detectDbType(con), con, sql, paramMap);
            ResultSet rs = stmt.executeQuery();
            List<T> res = beanType == null ? DBUtil.convertResultSetToBean(rs, beanType, this.detectDbType(con)) : DBUtil.convertResultSetToBean(rs, beanType, this.detectDbType(con));
            this.recordCostTime(t, sql);
            List<T> list = res;
            return list;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql:" + sql + " ,input:" + paramMap, (Throwable)e);
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public <T> List<T> queryForBean(String sql, Object[] args, Class<T> beanType) throws Exception {
        long t = System.currentTimeMillis();
        this.recordStartTime(t, sql);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = DBUtil.createPreparedStatement(this.detectDbType(con), con, sql, args);
            ResultSet rs = stmt.executeQuery();
            List<T> res = beanType == null ? DBUtil.convertResultSetToBean(rs, beanType, this.detectDbType(con)) : DBUtil.convertResultSetToBean(rs, beanType, this.detectDbType(con));
            this.recordCostTime(t, sql);
            List<T> list = res;
            return list;
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,sql:" + sql + " ,input:" + Arrays.toString(args), (Throwable)e);
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void callStoredProcedure(String call, Map<String, Object> importArgs) throws Exception {
        long t = System.currentTimeMillis();
        this.recordStartTime(t, call);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = DBUtil.createPreparedCall(this.detectDbType(con), con, call, importArgs);
            stmt.execute();
            this.recordCostTime(t, call);
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,call:" + call + " ,input:" + importArgs, (Throwable)e);
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public Object callFunction(String call, int outType, Map<String, Object> importArgs) throws Exception {
        long t = System.currentTimeMillis();
        Connection con = null;
        Statement stmt = null;
        Object ret = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = DBUtil.createFunctionCall(this.detectDbType(con), con, call, outType, importArgs);
            stmt.execute();
            ret = stmt.getObject(1);
            this.recordCostTime(t, call);
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,call:" + call + " ,input:" + importArgs, (Throwable)e);
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return ret;
    }

    public void callStoredProcedure(String call, Map<String, Object> importArgs, Map<String, Object> exportArgs) throws Exception {
        long t = System.currentTimeMillis();
        this.recordStartTime(t, call);
        Connection con = null;
        Statement stmt = null;
        try {
            con = this.getConnection();
            con.setAutoCommit(true);
            stmt = DBUtil.createPreparedCall(this.detectDbType(con), con, call, importArgs);
            stmt.execute();
            if (exportArgs != null) {
                ResultSet rs = stmt.getResultSet();
                for (Map.Entry<String, Object> entry : exportArgs.entrySet()) {
                    Object val = rs.getObject(entry.getKey());
                    entry.setValue(val);
                }
            }
            this.recordCostTime(t, call);
        }
        catch (Exception e) {
            logger.error(e.getMessage() + " ,call:" + call + " ,input:" + importArgs, (Throwable)e);
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void recordStartTime(long startTime, String sql) {
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[start]sql:");
            sb.append(sql);
            sb.append(" start time:");
            sb.append(startTime);
            logger.debug(sb.toString());
        }
    }

    public void recordCostTime(long startTime, String sql) {
        long endTime = System.currentTimeMillis();
        long costTime = endTime - startTime;
        StringBuilder sb = new StringBuilder();
        sb.append("[end]sql:");
        sb.append(sql);
        sb.append(" cost time:");
        sb.append(costTime);
        logger.error(sb.toString());
        totalCostTime += costTime;
        if (++accessCount % 1000 == 0) {
            sb = new StringBuilder();
            sb.append("database operation average cost time is ");
            sb.append(totalCostTime / (long)accessCount);
            logger.error(sb.toString());
        }
    }

    public String getSequenceValue(String seqkey, int intSeqLen) throws Exception {
        long t = System.currentTimeMillis();
        Statement stmt = null;
        ResultSet result = null;
        Connection con = null;
        try {
            DataSource dataS = (DataSource)SpringContextHolder.getApplicationContext().getBean("dataSource");
            con = dataS.getConnection();
            String dbtype = this.detectDbType(con);
            String sql = "";
            if ("ORACLE".equals(dbtype)) {
                sql = String.format("SELECT %s.nextval FROM dual", seqkey.trim());
            } else if ("DB2".equals(dbtype)) {
                sql = String.format("SELECT nextval FOR %s FROM sysibm.sysdummy1", seqkey.trim());
            } else if ("MySQL".equals(dbtype)) {
                sql = String.format("select _nextval('%s') as current ", seqkey.trim());
            } else {
                throw new Exception("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b");
            }
            stmt = con.createStatement();
            result = stmt.executeQuery(sql.toString());
            int rows = 0;
            String sequenceStr = null;
            while (result.next()) {
                ++rows;
                sequenceStr = result.getString(1);
            }
            if (rows != 1) {
                throw new Exception("\u83b7\u53d6\u5e8f\u53f7\u503c\u4fe1\u606f\u5f02\u5e38,\u7ed3\u679c\u96c6\u4e0d\u4e3a1\u6761");
            }
            int resultLength = sequenceStr.length();
            if (sequenceStr != null && !sequenceStr.isEmpty() && sequenceStr.length() < intSeqLen) {
                for (int i = 0; i < intSeqLen - resultLength; ++i) {
                    sequenceStr = "0" + sequenceStr;
                }
            }
            this.recordCostTime(t, sql);
            String string = sequenceStr;
            return string;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

