/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.common.enums;

import org.springframework.util.StringUtils;

public enum ActionNodeType {
    START("START", "Start", "cn.com.yusys.yusp.commons.fee.core.component.action.StartAction"),
    END("END", "End", "cn.com.yusys.yusp.commons.fee.core.component.action.FlowEndAction"),
    SETVALUE("SETVALUE", "SetValue", "cn.com.yusys.yusp.commons.fee.core.component.action.AssignAction"),
    OBJSETVALUE("OBJSETVALUE", "OBJSETVALUE", "cn.com.yusys.yusp.commons.fee.core.component.action.ObjAssignAction"),
    SUBFLOW("SUBFLOW", "SubFlow", "cn.com.yusys.yusp.commons.fee.core.component.action.SubFlowAction"),
    BIZ("BIZ", "Biz", "cn.com.yusys.yusp.commons.fee.core.component.action.LogicAction"),
    MAPPER("MAPPER", "MAPPER", "cn.com.yusys.yusp.commons.fee.core.component.action.MybatisAction"),
    LOOP("LOOP_START", "LoopStart", "cn.com.yusys.yusp.commons.fee.core.component.action.loop.LoopAction"),
    LOOP_END("LOOP_END", "LoopEnd", "cn.com.yusys.yusp.commons.fee.core.component.action.loop.LoopEndAction"),
    JAVASCRIPT("JAVASCRIPT", "JavaScript", "cn.com.yusys.yusp.commons.fee.core.component.action.JavaScriptAction"),
    DB("DB", "DB", "cn.com.yusys.yusp.commons.fee.core.component.action.DBAction"),
    RADIO("RADIO", "Radio", "cn.com.yusys.yusp.commons.fee.core.component.action.BridgeAction"),
    STEP("STEP", "Step", "cn.com.yusys.yusp.commons.fee.core.component.action.StepAction"),
    STEP_START("STEP_START", "StepStart", "cn.com.yusys.yusp.commons.fee.core.component.action.BridgeAction"),
    STEP_END("STEP_END", "StepEnd", "cn.com.yusys.yusp.commons.fee.core.component.action.StepEndAction"),
    COMMUNICAT("COMMUNICAT", "Communicat", "cn.com.yusys.yusp.commons.fee.core.component.action.CommunicatAction"),
    PARALLEL_START("PARALLEL_START", "ParallelStart", "cn.com.yusys.yusp.commons.fee.core.component.action.ConcurrentStartAction"),
    PARALLEL_END("PARALLEL_END", "ParallelEnd", "cn.com.yusys.yusp.commons.fee.core.component.action.ConcurrentCloseAction"),
    NEW_OBJECT("NEW_OBJECT", "NewObject", "cn.com.yusys.yusp.commons.fee.core.component.action.NewObjectAction"),
    THROW_EXCEPTION("THROW_EXCEPTION", "ThrowException", "cn.com.yusys.yusp.commons.fee.core.component.action.ThrowExceptionAction"),
    COMMON_FLOW("COMMON_FLOW", "CommonFlow", "cn.com.yusys.yusp.commons.fee.core.component.action.CommonFlowAction");

    private String value;
    private String name;
    private String action;

    private ActionNodeType(String value, String name, String action) {
        this.value = value;
        this.name = name;
        this.action = action;
    }

    public String getValue() {
        return this.value;
    }

    public String getAction() {
        return this.action;
    }

    public String getName() {
        return this.name;
    }

    public static ActionNodeType getNodeType(String value) {
        if (StringUtils.isEmpty((Object)value)) {
            return null;
        }
        for (ActionNodeType actionNodeType : ActionNodeType.values()) {
            if (!actionNodeType.value.equalsIgnoreCase(value)) continue;
            return actionNodeType;
        }
        return null;
    }

    public static String getAction(String value) {
        ActionNodeType actionNodeType = ActionNodeType.getNodeType(value);
        if (actionNodeType != null) {
            return actionNodeType.getAction();
        }
        return null;
    }

    public static String getActionName(String value) {
        ActionNodeType actionNodeType = ActionNodeType.getNodeType(value);
        if (actionNodeType != null) {
            return actionNodeType.getName();
        }
        return null;
    }
}

