/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.common.util;

import cn.com.yusys.yusp.commons.fee.common.constant.FeeConstants;
import cn.com.yusys.yusp.commons.fee.common.util.ClassUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.Map;

public class MessageFormat {
    public static String expand(String template, Map<String, ?> variables) {
        if (template == null) {
            return template;
        }
        if (template.length() < 3) {
            return template;
        }
        if (variables == null) {
            return null;
        }
        boolean inVar = false;
        StringBuilder var = new StringBuilder();
        StringBuilder builder = new StringBuilder();
        block4: for (char c : template.toCharArray()) {
            switch (c) {
                case '{': {
                    if (inVar) {
                        builder.append("{");
                        inVar = false;
                        continue block4;
                    }
                    inVar = true;
                    continue block4;
                }
                case '}': {
                    if (!inVar) {
                        builder.append('}');
                        continue block4;
                    }
                    inVar = false;
                    String key = var.toString();
                    Object value = variables.get(var.toString());
                    if (value != null) {
                        builder.append(value);
                    } else {
                        builder.append('{').append(key).append('}');
                    }
                    var = new StringBuilder();
                    continue block4;
                }
                default: {
                    if (inVar) {
                        var.append(c);
                        continue block4;
                    }
                    builder.append(c);
                }
            }
        }
        return builder.toString();
    }

    public static String queryLine(String api, Object object) throws UnsupportedEncodingException {
        if (api == null) {
            return null;
        }
        if (object == null) {
            return api;
        }
        StringBuilder queryBuilder = new StringBuilder();
        if (ClassUtil.isBaseTypebyObject(object)) {
            if (!api.contains("?")) {
                api = api + "?";
            }
            queryBuilder.append(api);
            queryBuilder.append('&');
            queryBuilder.append(object);
        } else {
            for (Field field : object.getClass().getDeclaredFields()) {
                Object objValue = ClassUtil.getObjectFieldValue(object, field);
                if (objValue == null) continue;
                String value = URLEncoder.encode(String.valueOf(objValue), FeeConstants.UTF_8.name());
                queryBuilder.append('&');
                queryBuilder.append(field.getName());
                if (value == null || value.isEmpty()) continue;
                queryBuilder.append('=');
                queryBuilder.append(value);
            }
            if (api.indexOf("?") > 0) {
                queryBuilder.insert(0, api);
            } else {
                queryBuilder.deleteCharAt(0);
                queryBuilder.insert(0, '?');
                queryBuilder.insert(0, api);
            }
        }
        return queryBuilder.toString();
    }
}

