/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.common.util;

import cn.com.yusys.yusp.commons.fee.common.util.SpringContextHolder;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ClassUtil {
    private static final Logger logger = LoggerFactory.getLogger(ClassUtil.class);
    private static final Map<String, Method> CACHE_FIELD_SETTER = new HashMap<String, Method>();
    private static final Map<String, Method> CACHE_FIELD_GETTER = new HashMap<String, Method>();

    public static boolean isBasicType(StringBuilder className) {
        boolean isBasicType = false;
        if (!StringUtils.isEmpty((Object)className)) {
            String name;
            if (!className.toString().contains(".")) {
                String convertedName = ClassUtil.convertBasicType(className.toString());
                className.replace(0, className.length(), "").append(convertedName);
            }
            if ((name = className.toString()).startsWith("java.lang.")) {
                isBasicType = "java.lang.String".equals(name) || "java.lang.Integer".equals(name) || "java.lang.Long".equals(name) || "java.lang.Short".equals(name) || "java.lang.Boolean".equals(name) || "java.lang.Byte".equals(name) || "java.lang.Double".equals(name) || "java.lang.Float".equals(name);
            }
        }
        return isBasicType;
    }

    public static String convertBasicType(String className, boolean isArray) {
        String newClassName = ClassUtil.convertBasicType(className);
        if (isArray) {
            newClassName = "[L" + newClassName + ";";
        }
        return newClassName;
    }

    public static String convertBasicType(String className) {
        String newClassName = className;
        if ("String".equalsIgnoreCase(className)) {
            newClassName = "java.lang.String";
        } else if ("int".equalsIgnoreCase(className)) {
            newClassName = "java.lang.Integer";
        } else if ("long".equalsIgnoreCase(className)) {
            newClassName = "java.lang.Long";
        } else if ("short".equalsIgnoreCase(className)) {
            newClassName = "java.lang.Short";
        } else if ("boolean".equalsIgnoreCase(className)) {
            newClassName = "java.lang.Boolean";
        } else if ("byte".equalsIgnoreCase(className)) {
            newClassName = "java.lang.Byte";
        } else if ("double".equalsIgnoreCase(className)) {
            newClassName = "java.lang.Double";
        } else if ("float".equalsIgnoreCase(className)) {
            newClassName = "java.lang.Float";
        }
        return newClassName;
    }

    public static Map<String, Class> getFieldType(Class clazz) {
        HashMap<String, Class> fieldMap = new HashMap<String, Class>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor p : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String fieldName = p.getName();
                Method readMethod = p.getReadMethod();
                Method writeMethod = p.getWriteMethod();
                if (readMethod == null || writeMethod == null) continue;
                fieldMap.put(fieldName, p.getPropertyType());
            }
        }
        catch (IntrospectionException e) {
            logger.error("", (Throwable)e);
        }
        return fieldMap;
    }

    public static Map<String, Method> getFieldSetter(Class<?> clazz) {
        HashMap<String, Method> setterMethodMap = new HashMap<String, Method>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor p : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String fieldName = p.getName();
                Method readMethod = p.getReadMethod();
                Method writeMethod = p.getWriteMethod();
                if (readMethod == null || writeMethod == null) continue;
                setterMethodMap.put(fieldName, p.getWriteMethod());
            }
        }
        catch (IntrospectionException e) {
            logger.error("", (Throwable)e);
        }
        return setterMethodMap;
    }

    public static boolean isBaseTypebyObject(Object object) {
        if (object == null) {
            return false;
        }
        Class<?> className = object.getClass();
        return className.equals(Integer.class) || className.equals(Byte.class) || className.equals(Long.class) || className.equals(Double.class) || className.equals(Float.class) || className.equals(Character.class) || className.equals(Short.class) || className.equals(Boolean.class) || className.equals(String.class);
    }

    public static Set<String> getFieldNames(Class<?> clazz) {
        HashSet<String> fieldNames = new HashSet<String>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor p : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method getter = p.getReadMethod();
                Method setter = p.getWriteMethod();
                if (getter == null || setter == null) continue;
                fieldNames.add(p.getName());
            }
        }
        catch (IntrospectionException e) {
            logger.error("", (Throwable)e);
        }
        return fieldNames;
    }

    public static final Field getField(Object object, String fieldName) {
        try {
            return object.getClass().getDeclaredField(fieldName);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6Class[{}]\u7684\u5b57\u6bb5[{}]\u5f02\u5e38!", (Object)object.getClass().getCanonicalName(), (Object)fieldName);
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static final Object newInstance(Class<?> classt) {
        try {
            return classt.newInstance();
        }
        catch (Exception e) {
            logger.error("Class[{}]\u5b9e\u4f8b\u5316\u51fa\u73b0\u5f02\u5e38!", (Object)classt.getCanonicalName());
            logger.error("", (Throwable)e);
            return null;
        }
    }

    public static final Object newInstance(String className) throws Exception {
        Object newInstance = null;
        newInstance = "boolean".equals(className) ? Boolean.valueOf(true) : ("byte".equals(className) ? Integer.valueOf(0) : ("int".equals(className) ? Integer.valueOf(0) : ("long".equals(className) ? Long.valueOf(0L) : ("double".equals(className) ? Double.valueOf(0.0) : ("float".equals(className) ? Double.valueOf(0.0) : ("short".equals(className) ? Integer.valueOf(0) : ("java.lang.Boolean".equals(className) ? Boolean.TRUE : ("java.lang.Byte".equals(className) ? Byte.valueOf("0") : ("java.lang.Integer".equals(className) ? Integer.valueOf("0") : ("java.lang.Long".equals(className) ? Long.valueOf("0") : ("java.lang.Double".equals(className) ? Double.valueOf("0.00") : ("java.lang.Float".equals(className) ? Float.valueOf("0.00") : ("java.lang.Short".equals(className) ? Short.valueOf("0") : ("java.util.Map".equals(className) ? new HashMap() : ("java.util.List".equals(className) ? new ArrayList() : ("java.util.Set".equals(className) ? new HashSet() : Class.forName(className).newInstance()))))))))))))))));
        return newInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setObjectFieldValue(Object object, Field field, Object value) {
        boolean isAccessible = field.isAccessible();
        try {
            if (!isAccessible) {
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        finally {
            if (!isAccessible) {
                field.setAccessible(false);
            }
        }
    }

    public static final Object createObjectFieldInstance(Object object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            return field.getClass().newInstance();
        }
        catch (Throwable e) {
            logger.error("", e);
            return null;
        }
    }

    public static final Object getObjectFieldValue(Object object, String fieldName) {
        try {
            Field field = object.getClass().getDeclaredField(fieldName);
            return ClassUtil.getObjectFieldValue(object, field);
        }
        catch (Throwable e) {
            logger.error("", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object getObjectFieldValue(Object object, Field field) {
        boolean isAccessible = field.isAccessible();
        try {
            if (!isAccessible) {
                field.setAccessible(true);
            }
            Object object2 = field.get(object);
            return object2;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        finally {
            if (!isAccessible) {
                field.setAccessible(false);
            }
        }
        return null;
    }

    public static final Object getObjectFieldValue(Object object, String clazzName, String fieldName) {
        try {
            Class clazz = ClassUtils.forName((String)clazzName, (ClassLoader)ClassUtils.getDefaultClassLoader());
            if (ClassUtils.isAssignableValue((Class)clazz, (Object)object)) {
                Field field = object.getClass().getDeclaredField(fieldName);
                return ClassUtil.getObjectFieldValue(object, field);
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
        return null;
    }

    public static final Method getSetter(Object object, Field field) {
        String key = object.getClass().getCanonicalName() + "_" + field.getName();
        if (!CACHE_FIELD_SETTER.containsKey(key)) {
            String name = "set" + field.getName().substring(0, 1).toUpperCase(Locale.ENGLISH) + field.getName().substring(1);
            try {
                Method method = object.getClass().getMethod(name, field.getType());
                CACHE_FIELD_SETTER.put(key, method);
                return method;
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        return CACHE_FIELD_SETTER.get(key);
    }

    public static final Method getGetter(Object object, Field field) {
        String key = object.getClass().getCanonicalName() + "_" + field.getName();
        if (!CACHE_FIELD_GETTER.containsKey(key)) {
            String name = "get" + field.getName().substring(0, 1).toUpperCase(Locale.ENGLISH) + field.getName().substring(1);
            try {
                Method method = object.getClass().getMethod(name, null);
                CACHE_FIELD_GETTER.put(key, method);
                return method;
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
        return CACHE_FIELD_GETTER.get(key);
    }

    public static final void setFieldValue(Object object, Field field, Object value) {
        try {
            Method method = ClassUtil.getSetter(object, field);
            method.invoke(object, value);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            logger.error("\u53c2\u6570\u8bbe\u7f6e\u5f02\u5e38,\u53c2\u6570\u7c7b\u578b[{}],\u503c\u7c7b\u578b[{}]", field.getType(), value.getClass());
        }
    }

    public static final Class<?> strToClass(String className) throws ClassNotFoundException {
        return ClassUtil.strToClass2(className, false);
    }

    public static <T> T getCallObject(Class<T> classType) {
        T object = SpringContextHolder.getBeanIfExist(classType);
        if (object != null) {
            return object;
        }
        try {
            object = classType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.error("", (Throwable)e);
        }
        return object;
    }

    public static Class<?> strToClass(String className, boolean isArray) throws ClassNotFoundException {
        String newClassName = ClassUtil.convertBasicType(className, isArray);
        return Class.forName(newClassName);
    }

    public static Class<?> strToClass2(String className, boolean array) throws ClassNotFoundException {
        Class<Object> classes = "boolean".equals(className) ? (array ? Class.forName("[Z") : Boolean.TYPE) : ("byte".equals(className) ? (array ? Class.forName("[B") : Byte.TYPE) : ("int".equals(className) ? (array ? Class.forName("[I") : Integer.TYPE) : ("long".equals(className) ? (array ? Class.forName("[J") : Long.TYPE) : ("double".equals(className) ? (array ? Class.forName("[D") : Double.TYPE) : ("float".equals(className) ? (array ? Class.forName("[F") : Float.TYPE) : ("short".equals(className) ? (array ? Class.forName("[S") : Short.TYPE) : (array ? Class.forName("[L" + className + ";") : Class.forName(className))))))));
        return classes;
    }

    public static Object newBaseTypeObject(String className) {
        if ("boolean".equalsIgnoreCase(className)) {
            return false;
        }
        if ("byte".equalsIgnoreCase(className)) {
            return (byte)0;
        }
        if ("int".equalsIgnoreCase(className)) {
            return 0;
        }
        if ("long".equalsIgnoreCase(className)) {
            return 0L;
        }
        if ("double".equalsIgnoreCase(className)) {
            return 0.0;
        }
        if ("float".equalsIgnoreCase(className)) {
            return Float.valueOf(0.0f);
        }
        if ("short".equalsIgnoreCase(className)) {
            return (short)0;
        }
        if ("String".equalsIgnoreCase(className)) {
            return "";
        }
        return null;
    }

    public static <T> T[] objectToArray(Class<T> classType, Object object) {
        if (object == null) {
            return null;
        }
        if (classType == null) {
            return null;
        }
        int length = Array.getLength(object);
        Object[] tArray = (Object[])Array.newInstance(classType, length);
        for (int i = 0; i < length; ++i) {
            tArray[i] = Array.get(object, i);
        }
        return tArray;
    }

    public static Object strToObject(String param, Class<?> clazz) throws Exception {
        if (param == null) {
            return null;
        }
        Object res = null;
        if (Byte.TYPE == clazz || Byte.class == clazz) {
            if (param.length() > 0) {
                res = Byte.valueOf(param);
            }
        } else if (Short.TYPE == clazz || Short.class == clazz) {
            if (param.length() > 0) {
                res = Short.valueOf(param);
            }
        } else if (Integer.TYPE == clazz || Integer.class == clazz) {
            if (param.length() > 0) {
                res = Integer.valueOf(param);
            }
        } else if (Long.TYPE == clazz || Long.class == clazz) {
            if (param.length() > 0) {
                res = Long.valueOf(param);
            }
        } else if (Float.TYPE == clazz || Float.class == clazz) {
            if (param.length() > 0) {
                res = Float.valueOf(param);
            }
        } else if (Double.TYPE == clazz || Double.class == clazz) {
            if (param.length() > 0) {
                res = Double.valueOf(param);
            }
        } else if (Character.TYPE == clazz || Character.class == clazz) {
            res = Character.valueOf(param.charAt(0));
        } else if (Boolean.TYPE == clazz || Boolean.class == clazz) {
            if (param.length() > 0) {
                res = Boolean.parseBoolean(param);
            }
        } else if (CharSequence.class.isAssignableFrom(clazz)) {
            res = param;
        } else if (java.util.Date.class.isAssignableFrom(clazz)) {
            if (param.length() > 0) {
                try {
                    long time = Long.valueOf(param);
                    Constructor<?> constructor = clazz.getConstructor(Long.TYPE);
                    res = constructor.newInstance(time);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            res = clazz.newInstance();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String objectToStr(Object param) throws Exception {
        if (param == null) {
            return null;
        }
        Class<?> clazz = param.getClass();
        String res = null;
        if (Byte.TYPE == clazz || Byte.class == clazz) {
            res = param.toString();
        } else if (Short.TYPE == clazz || Short.class == clazz) {
            res = param.toString();
        } else if (Integer.TYPE == clazz || Integer.class == clazz) {
            res = param.toString();
        } else if (Long.TYPE == clazz || Long.class == clazz) {
            res = param.toString();
        } else if (Float.TYPE == clazz || Float.class == clazz) {
            String s = param.toString();
            res = ClassUtil.converExponentFormatStr(s);
        } else if (Double.TYPE == clazz || Double.class == clazz) {
            String s = param.toString();
            res = ClassUtil.converExponentFormatStr(s);
        } else if (Character.TYPE == clazz || Character.class == clazz) {
            res = param.toString();
        } else if (Boolean.TYPE == clazz || Boolean.class == clazz) {
            res = param.toString();
        } else if (CharSequence.class.isAssignableFrom(clazz)) {
            res = param.toString();
        } else if (Clob.class.isAssignableFrom(clazz)) {
            Clob clob = (Clob)param;
            try (Reader reader = clob.getCharacterStream();){
                int len = (int)clob.length();
                char[] chars = new char[len];
                reader.read(chars);
                res = new String(chars);
            }
        } else {
            res = param.toString();
        }
        return res;
    }

    private static String converExponentFormatStr(String s) {
        String res = s;
        int index = s.toUpperCase().indexOf(69);
        if (index != -1) {
            int exponent = Integer.parseInt(s.substring(index + 1));
            int doitIndex = s.indexOf(46);
            String intPart = s.substring(0, doitIndex);
            String doitPart = doitIndex != -1 ? s.substring(doitIndex + 1, index) : "";
            StringBuilder sb = new StringBuilder();
            if (exponent > 0) {
                sb.append(intPart);
                int size = doitPart.length();
                if (exponent == size) {
                    sb.append(doitPart);
                } else if (exponent < size) {
                    String numPart = doitPart.substring(0, exponent);
                    sb.append(numPart);
                    sb.append(".");
                    String decPart = doitPart.substring(exponent);
                    sb.append(decPart);
                } else {
                    sb.append(doitPart);
                    for (int i = 0; i < exponent - size; ++i) {
                        sb.append("0");
                    }
                }
            } else {
                int size = intPart.length();
                if ((exponent *= -1) == size) {
                    sb.append(intPart);
                    sb.append(doitPart);
                } else if (exponent < size) {
                    int splitIndex = size - exponent;
                    sb.append(intPart.substring(0, splitIndex));
                    sb.append(".");
                    sb.append(intPart.substring(splitIndex));
                    sb.append(doitPart);
                } else {
                    sb.append("0.");
                    for (int i = 0; i < exponent - size; ++i) {
                        sb.append("0");
                    }
                    sb.append(intPart);
                    sb.append(doitPart);
                }
            }
            res = sb.toString();
        }
        return res;
    }

    public static boolean isBaseType(Object obj) {
        if (obj == null) {
            return true;
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return true;
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return true;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return true;
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return true;
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return true;
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return true;
        }
        if (clazz == Character.class || clazz == Character.TYPE) {
            return true;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (java.util.Date.class.isAssignableFrom(clazz)) {
            return true;
        }
        return clazz == Boolean.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convert(Object value, Class<?> expectedType) throws Exception {
        if (value == null) {
            return value;
        }
        Class<?> clazz = value.getClass();
        if (clazz == expectedType) {
            return value;
        }
        if (clazz == Date.class && expectedType == java.util.Date.class) {
            Date date = (Date)value;
            return new java.util.Date(date.getTime());
        }
        if (clazz == Timestamp.class && expectedType == java.util.Date.class) {
            Timestamp date = (Timestamp)value;
            return new java.util.Date(date.getTime());
        }
        if (clazz == Time.class && expectedType == java.util.Date.class) {
            Timestamp date = (Timestamp)value;
            return new java.util.Date(date.getTime());
        }
        if (byte[].class == expectedType) {
            if (Blob.class.isAssignableFrom(clazz)) {
                Blob blob = (Blob)value;
                int len = (int)blob.length();
                byte[] bytes = new byte[len];
                try (InputStream in = blob.getBinaryStream();){
                    in.read(bytes);
                    byte[] byArray = bytes;
                    return byArray;
                }
            }
            if (Byte[].class == clazz) {
                Byte[] buffer = (Byte[])value;
                byte[] bytes = new byte[buffer.length];
                for (int i = 0; i < buffer.length; ++i) {
                    bytes[i] = buffer[i];
                }
                return bytes;
            }
            return (byte[])value;
        }
        if (Byte[].class == expectedType) {
            if (Blob.class.isAssignableFrom(clazz)) {
                Blob blob = (Blob)value;
                int len = (int)blob.length();
                byte[] bytes = new byte[len];
                try (InputStream in = blob.getBinaryStream();){
                    in.read(bytes);
                    byte[] byArray = bytes;
                    return byArray;
                }
            }
            if (byte[].class == clazz) {
                byte[] buffer = (byte[])value;
                Byte[] bytes = new Byte[buffer.length];
                for (int i = 0; i < buffer.length; ++i) {
                    bytes[i] = buffer[i];
                }
                return bytes;
            }
            return (Byte[])value;
        }
        String s = ClassUtil.objectToStr(value);
        Object res = ClassUtil.strToObject(s, expectedType);
        return res;
    }

    private static String getGetter(String fieldName) {
        StringBuilder sb = new StringBuilder();
        sb.append("get");
        char c = fieldName.charAt(0);
        if (c >= 'a' && c <= 'z') {
            sb.append((char)(c - 32));
        } else {
            sb.append(c);
        }
        if (fieldName.length() > 1) {
            sb.append(fieldName.substring(1));
        }
        String getter = sb.toString();
        return getter;
    }

    private static String getSetter(String fieldName) {
        StringBuilder sb = new StringBuilder();
        sb.append("set");
        char c = fieldName.charAt(0);
        if (c >= 'a' && c <= 'z') {
            sb.append((char)(c - 32));
        } else {
            sb.append(c);
        }
        if (fieldName.length() > 1) {
            sb.append(fieldName.substring(1));
        }
        String setter = sb.toString();
        return setter;
    }

    public static void setFieldValue(Class<?> clazz, Object instance, String name, Object value) throws Exception {
        boolean flag = false;
        try {
            Class[] parameterTypes = new Class[1];
            String getter = ClassUtil.getGetter(name);
            Method getterMethod = clazz.getMethod(getter, new Class[0]);
            if (getterMethod != null) {
                parameterTypes[0] = getterMethod.getReturnType();
                String setter = ClassUtil.getSetter(name);
                Method setterMethod = clazz.getMethod(setter, parameterTypes);
                Object arg = ClassUtil.convert(value, parameterTypes[0]);
                setterMethod.invoke(instance, arg);
                flag = true;
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        if (!flag) {
            try {
                Field field = clazz.getDeclaredField(name);
                field.setAccessible(true);
                Class<?> parameterType = field.getType();
                Object arg = ClassUtil.convert(value, parameterType);
                field.set(instance, arg);
                flag = true;
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (!flag) {
            throw new Exception("field[" + name + "] not exist");
        }
    }

    public static Object getFieldValue(Class<?> clazz, Object instance, String name) throws Exception {
        try {
            String getter = ClassUtil.getGetter(name);
            Method getterMethod = clazz.getMethod(getter, new Class[0]);
            if (getterMethod != null) {
                Object res = getterMethod.invoke(instance, new Object[0]);
                return res;
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            Object res = field.get(instance);
            return res;
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new Exception("field[" + name + "] not exist");
        }
    }

    public static Map<String, Field> getFields(Class<?> clazz) {
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        Class<?> c = clazz;
        do {
            for (Field field : c.getDeclaredFields()) {
                if ((field.getModifiers() & 0x88) != 0 || fields.put(field.getName(), field) == null) continue;
                throw new RuntimeException("duplicate field exception");
            }
        } while ((c = c.getSuperclass()) != null);
        return fields;
    }
}

