/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.common.exception;

import cn.com.yusys.yusp.commons.fee.common.exception.FeeException;
import cn.com.yusys.yusp.commons.fee.common.util.MdcParamUtil;

public enum Error {
    INNER_ERROR("000001", "\u5185\u90e8\u9519\u8bef"),
    NOT_FOUND("000002", "\u6ca1\u6709\u627e\u5230\u63a5\u53e3"),
    XML_PARSE_ERROR("000003", "xml\u89e3\u6790\u5f02\u5e38"),
    API_REGISTRY_ERROR("000004", "API\u6ce8\u518c\u5f02\u5e38"),
    NO_REQUIRED_BEAN("000005", "\u7f3a\u5c11\u5fc5\u8981\u7684bean"),
    ING("100000", "\u6b63\u5728\u8fd0\u884c\u4e2d\uff0c\u8bf7\u7a0d\u7b49"),
    ACTION_ASYNC_FAILED("100001", "\u7ec4\u4ef6\u5f02\u6b65\u6267\u884c\u5f02\u5e38\u7ec8\u6b62"),
    ACTION_NEXT_NULL("100002", "\u7ec4\u4ef6\u4e0b\u4e00\u4e2a\u8282\u70b9\u672a\u627e\u5230"),
    ACTION_CONCURRENT_CLOSE_FAILED("100003", "\u5e76\u53d1\u7ec4\u4ef6\u5173\u95ed\u5f02\u5e38"),
    ACTION_NO_PARAMS("100004", "\u7ec4\u4ef6\u6ca1\u6709\u53c2\u6570"),
    ACTION_LACK_ATTRIBUTE("100005", "\u7ec4\u4ef6\u7f3a\u5c11\u5fc5\u8981\u5c5e\u6027"),
    ACTION_ATTRIBUTE_EXCEPTION("100006", "\u7ec4\u4ef6\u5c5e\u6027\u5f02\u5e38"),
    ACTION_TYPE_EXCEPTION("100007", "\u7ec4\u4ef6\u7c7b\u578b\u5f02\u5e38"),
    ASSIGN_TYPE_INVALID("100008", "\u6570\u636e\u503c\u548c\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8f6c\u6362\u65e0\u6548"),
    IDEMPOTENT_ERROR("100009", "\u5e42\u7b49\u5f02\u5e38"),
    NO_START_ACTION("100010", "\u6ca1\u6709\u5f00\u59cb\u8282\u70b9"),
    MULTIPLE_START_ACTION("100011", "\u591a\u4e2a\u5f00\u59cb\u8282\u70b9"),
    ACTION_NO_LEFT_PARAM("100012", "\u53d8\u91cf\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"),
    COMMUNICATE_MS_FAILED("110001", "\u5fae\u670d\u52a1\u8bf7\u6c42\u5931\u8d25"),
    COMMUNICATE_BSP_FAILED("110002", "Bsp\u901a\u8baf\u5931\u8d25"),
    CONTEXT_NO_PARAMS("110003", "\u4e0a\u4e0b\u6587\u6ca1\u6709\u53c2\u6570"),
    FLOW_CHK_INVALID("110004", "\u6d41\u7a0b\u68c0\u67e5\u672a\u901a\u8fc7"),
    FLOW_RUN_EXCEPTION("110005", "\u6d41\u7a0b\u5f02\u5e38\u7ec8\u6b62"),
    INVOKE_CALL_CLASSNOTFOUND("130001", "\u7c7b\u4fe1\u606f\u672a\u627e\u5230"),
    INVOKE_CALL_NOSUCHMETHOD("130002", "\u65b9\u6cd5\u672a\u627e\u5230"),
    INVOKE_CALL_ILLEGALACCESS("130003", "\u65b9\u6cd5\u65e0\u6743\u9650\u8bbf\u95ee"),
    INVOKE_CALL_ILLEGALARGUMENT("130004", "\u53c2\u6570\u6570\u91cf\u6216\u7c7b\u578b\u65e0\u6548"),
    INVOKE_CALL_FAILED("130005", "\u65b9\u6cd5\u6267\u884c\u5f02\u5e38"),
    PARAM_CONVERT_ERROR("130006", "\u53c2\u6570\u8f6c\u6362\u9519\u8bef"),
    ZK_INIT_ERROR("140001", "ZK\u914d\u7f6e\u9519\u8bef"),
    ZK_NOT_GET_LOCK("140002", "\u6ca1\u6709\u5f97\u5230\u9501"),
    ZK_LOCK_TIMEOUT("140003", "\u83b7\u53d6\u9501\u8d85\u65f6"),
    RSA_INIT_ERROR("150001", "RSA\u521d\u59cb\u5316\u5f02\u5e38"),
    RSA_PUBLICKEY_ERROR("150002", "\u516c\u94a5\u52a0,\u89e3\u5bc6\u5f02\u5e38\u7ec8\u6b62"),
    RSA_PRIVATEKEY_ERROR("150003", "\u79c1\u94a5\u52a0,\u89e3\u5bc6\u5f02\u5e38\u7ec8\u6b62"),
    SCRIPT_EXECUTE_FAILED("150004", "\u52a8\u6001\u811a\u672c\u6267\u884c\u5f02\u5e38"),
    SUBFLOW_NOT_FOUND("150005", "\u6ca1\u6709\u627e\u5230\u5b50\u6d41\u7a0b"),
    COMMON_FLOW_NOT_FOUND("150006", "\u6ca1\u6709\u627e\u5230\u516c\u5171\u6d41\u7a0b"),
    TRANSITION_EXCP_EXCEPTION("150007", "\u5f02\u5e38\u8f6c\u79fb\u5339\u914d\u5f02\u5e38"),
    TRANSITION_ANALYZE_EXCEPTION("150008", "\u6761\u4ef6\u5206\u6790\u5f02\u5e38"),
    NOT_FOUND_VALUE("200001", " Map\u4e2d\u6ca1\u6709\u53d1\u73b0\u8be5\u503c"),
    SQL_ANALYZING_ERROR("200002", "SQL\u89e3\u6790\u9519\u8bef"),
    BSP_ANALYZING_ERROR("200003", "BSP\u89e3\u6790\u9519\u8bef"),
    BSP_FLOW_ERROR("200004", "BSP\u7f16\u6392\u914d\u7f6e\u9519\u8bef");

    private String errorCode;
    private String errorMessage;

    private Error(String errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public void throwNow() {
        throw new FeeException(this.errorCode, this.errorMessage);
    }

    public FeeException expcetion() {
        String traceInfo = this.createTraceInfo();
        String head = this.createHead();
        StringBuilder builder = new StringBuilder();
        builder.append(head);
        builder.append(this.errorMessage);
        FeeException ex = new FeeException(this.errorCode, builder.toString());
        ex.setTraceInfo(traceInfo);
        return ex;
    }

    public FeeException expcetion(String message) {
        String traceInfo = this.createTraceInfo();
        String head = this.createHead();
        StringBuilder builder = new StringBuilder();
        if (!message.startsWith(head)) {
            builder.append(head);
        }
        builder.append(this.errorMessage);
        builder.append(",");
        builder.append(message);
        FeeException ex = new FeeException(this.errorCode, builder.toString());
        ex.setTraceInfo(traceInfo);
        return ex;
    }

    private String createHead() {
        StringBuilder builder = new StringBuilder();
        if (MdcParamUtil.getParam("_flowId") != null) {
            builder.append("[");
            builder.append(MdcParamUtil.getParam("_flowId"));
            builder.append("]");
        }
        if (MdcParamUtil.getParam("_actionId") != null) {
            builder.append("[");
            builder.append(MdcParamUtil.getParam("_actionId"));
            builder.append("]");
        }
        return builder.toString();
    }

    private String createTraceInfo() {
        StackTraceElement[] stacks = new Throwable().getStackTrace();
        int index = stacks.length >= 3 ? 3 : stacks.length - 1;
        return String.format("file[%s] class[%s] method[%s] Line[%d]", stacks[index].getFileName(), stacks[index].getClassName(), stacks[index].getMethodName(), stacks[index].getLineNumber());
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

