/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.fee.common.enums;

import org.springframework.util.StringUtils;

public enum ActionNodeType {
    START("START", "\u5f00\u59cb", "cn.com.yusys.yusp.commons.fee.core.component.action.StartAction"),
    END("END", "\u7ed3\u675f", "cn.com.yusys.yusp.commons.fee.core.component.action.FlowEndAction"),
    SETVALUE("SETVALUE", "\u8d4b\u503c", "cn.com.yusys.yusp.commons.fee.core.component.action.AssignAction"),
    SUBFLOW("SUBFLOW", "\u5b50\u6d41\u7a0b", "cn.com.yusys.yusp.commons.fee.core.component.action.SubFlowAction"),
    BIZ("BIZ", "\u903b\u8f91", "cn.com.yusys.yusp.commons.fee.core.component.action.LogicAction"),
    MAPPER("MAPPER", "MAPPER", "cn.com.yusys.yusp.commons.fee.core.component.action.MybatisAction"),
    LOOP("LOOP_START", "\u5faa\u73af\u5f00\u59cb", "cn.com.yusys.yusp.commons.fee.core.component.action.loop.LoopAction"),
    LOOP_END("LOOP_END", "\u5faa\u73af\u7ed3\u675f", "cn.com.yusys.yusp.commons.fee.core.component.action.loop.LoopEndAction"),
    JAVASCRIPT("JAVASCRIPT", "Java\u811a\u672c", "cn.com.yusys.yusp.commons.fee.core.component.action.JavaScriptAction"),
    DB("DB", "DB", "cn.com.yusys.yusp.commons.fee.core.component.action.DBAction"),
    RADIO("RADIO", "\u5355\u9009\u8282\u70b9", "cn.com.yusys.yusp.commons.fee.core.component.action.BridgeAction"),
    STEP("STEP", "\u6b65\u9aa4", "cn.com.yusys.yusp.commons.fee.core.component.action.StepAction"),
    STEP_START("STEP_START", "\u6b65\u9aa4\u5f00\u59cb", "cn.com.yusys.yusp.commons.fee.core.component.action.BridgeAction"),
    STEP_END("STEP_END", "\u6b65\u9aa4\u7ed3\u675f", "cn.com.yusys.yusp.commons.fee.core.component.action.StepEndAction"),
    COMMUNICAT("COMMUNICAT", "\u901a\u8baf", "cn.com.yusys.yusp.commons.fee.core.component.action.CommunicatAction"),
    PARALLEL("PARALLEL", "\u5e76\u884c", "cn.com.yusys.yusp.commons.fee.core.component.action.ConcurrentCloseAction"),
    NEW_OBJECT("NEW_OBJECT", "\u65b0\u5efa\u5bf9\u8c61", "cn.com.yusys.yusp.commons.fee.core.component.action.NewObjectAction"),
    THROW_EXCEPTION("THROW_EXCEPTION", "\u629b\u51fa\u5f02\u5e38", "cn.com.yusys.yusp.commons.fee.core.component.action.ThrowExceptionAction"),
    COMMON_FLOW("COMMON_FLOW", "\u516c\u5171\u6d41\u7a0b", "cn.com.yusys.yusp.commons.fee.core.component.action.CommonFlowAction");

    private String value;
    private String name;
    private String action;

    private ActionNodeType(String value, String name, String action) {
        this.value = value;
        this.name = name;
        this.action = action;
    }

    public String getValue() {
        return this.value;
    }

    public String getAction() {
        return this.action;
    }

    public String getName() {
        return this.name;
    }

    public static ActionNodeType getNodeType(String value) {
        if (StringUtils.isEmpty((Object)value)) {
            return null;
        }
        for (ActionNodeType actionNodeType : ActionNodeType.values()) {
            if (!actionNodeType.value.equalsIgnoreCase(value)) continue;
            return actionNodeType;
        }
        return null;
    }

    public static String getAction(String value) {
        ActionNodeType actionNodeType = ActionNodeType.getNodeType(value);
        if (actionNodeType != null) {
            return actionNodeType.getAction();
        }
        return null;
    }

    public static String getActionName(String value) {
        ActionNodeType actionNodeType = ActionNodeType.getNodeType(value);
        if (actionNodeType != null) {
            return actionNodeType.getName();
        }
        return null;
    }
}

