/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.echain.server.web.rest;

import cn.com.yusys.yusp.commons.mapper.QueryModel;
import cn.com.yusys.yusp.commons.web.rest.dto.ResultDto;
import cn.com.yusys.yusp.echain.server.domain.WfiSignTask;
import cn.com.yusys.yusp.echain.server.domain.dto.EchainJoinSignVoteDTO;
import cn.com.yusys.yusp.echain.server.domain.dto.EchainJoinTaskPoolDTO;
import cn.com.yusys.yusp.echain.server.domain.dto.EchainJoinWorkAgentEndDTO;
import cn.com.yusys.yusp.echain.server.domain.dto.EchainJoinWorkAgentTodoDTO;
import cn.com.yusys.yusp.echain.server.domain.dto.EchainJoinWorkEndDTO;
import cn.com.yusys.yusp.echain.server.domain.dto.EchainJoinWorkTodoDTO;
import cn.com.yusys.yusp.echain.server.service.EchainJoinBenchService;
import com.ecc.echain.workflow.cache.WFClientInstuCache;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/joinbeanch"})
public class EchainJoinBenchResource {
    @Autowired
    private EchainJoinBenchService echainJoinService;

    @GetMapping(value={"/getUserTodos"})
    public ResultDto<List<EchainJoinWorkTodoDTO>> getUserTodos(QueryModel model) {
        model.getCondition().put("loginCode", "" + model.getCondition().get("sessionLoginCode"));
        List<EchainJoinWorkTodoDTO> todos = this.echainJoinService.selectUserTodos(model);
        return new ResultDto(todos);
    }

    @GetMapping(value={"/getUserDones"})
    public ResultDto<List<EchainJoinWorkTodoDTO>> getUserDones(QueryModel model) {
        model.getCondition().put("loginCode", "" + model.getCondition().get("sessionLoginCode"));
        List<EchainJoinWorkTodoDTO> todos = this.echainJoinService.selectUserDones(model);
        return new ResultDto(todos);
    }

    @GetMapping(value={"/getUserEnds"})
    public ResultDto<List<EchainJoinWorkEndDTO>> getUserEnds(QueryModel model) {
        model.getCondition().put("loginCode", "" + model.getCondition().get("sessionLoginCode"));
        List<EchainJoinWorkEndDTO> todos = this.echainJoinService.selectUserEnds(model);
        return new ResultDto(todos);
    }

    @GetMapping(value={"/getUserInitTodos"})
    public ResultDto<List<EchainJoinWorkTodoDTO>> getUserInitTodos(QueryModel model) {
        model.getCondition().put("loginCode", "" + model.getCondition().get("sessionLoginCode"));
        List<EchainJoinWorkTodoDTO> todos = this.echainJoinService.selectUserInitTodos(model);
        return new ResultDto(todos);
    }

    @GetMapping(value={"/getUserInitEnds"})
    public ResultDto<List<EchainJoinWorkEndDTO>> getUserInitEnds(QueryModel model) {
        model.getCondition().put("loginCode", "" + model.getCondition().get("sessionLoginCode"));
        List<EchainJoinWorkEndDTO> todos = this.echainJoinService.selectUserInitEnds(model);
        return new ResultDto(todos);
    }

    @GetMapping(value={"/getUserAgentTodos"})
    public ResultDto<List<EchainJoinWorkAgentTodoDTO>> getUserAgentTodos(QueryModel model) {
        model.getCondition().put("loginCode", "" + model.getCondition().get("sessionLoginCode"));
        List<EchainJoinWorkAgentTodoDTO> todos = this.echainJoinService.selectUserAgentTodos(model);
        return new ResultDto(todos);
    }

    @GetMapping(value={"/getUserAgentEnds"})
    public ResultDto<List<EchainJoinWorkAgentEndDTO>> getUserAgentEnds(QueryModel model) {
        model.getCondition().put("loginCode", "" + model.getCondition().get("sessionLoginCode"));
        List<EchainJoinWorkAgentEndDTO> todos = this.echainJoinService.selectUserAgentEnds(model);
        return new ResultDto(todos);
    }

    @GetMapping(value={"/getUserHangTodos"})
    public ResultDto<List<EchainJoinWorkTodoDTO>> getUserHangTodos(QueryModel model) {
        model.getCondition().put("loginCode", "" + model.getCondition().get("sessionLoginCode"));
        List<EchainJoinWorkTodoDTO> todos = this.echainJoinService.selectUserHangTodos(model);
        return new ResultDto(todos);
    }

    @GetMapping(value={"/getUserTaskPools"})
    public ResultDto<List<EchainJoinTaskPoolDTO>> getUserTaskPools(QueryModel model) {
        model.getCondition().put("loginCode", "" + model.getCondition().get("sessionLoginCode"));
        String sysId = WFClientInstuCache.getInstance().getClientSign("" + model.getCondition().get("sessionInstuCde"));
        model.getCondition().put("sysId", sysId);
        List<EchainJoinTaskPoolDTO> taskPools = this.echainJoinService.selectUserTaskPools(model);
        return new ResultDto(taskPools);
    }

    @GetMapping(value={"/getUserTaskPoolTodos"})
    public ResultDto<List<EchainJoinWorkTodoDTO>> getUserTaskPoolTodos(QueryModel model) {
        model.getCondition().put("loginCode", "T." + model.getCondition().get("tpid"));
        List<EchainJoinWorkTodoDTO> todos = this.echainJoinService.selectUserTodos(model);
        return new ResultDto(todos);
    }

    @GetMapping(value={"/getUserSignTasks"})
    public ResultDto<List<WfiSignTask>> getUserSignTasks(QueryModel model) {
        model.getCondition().put("loginCode", "" + model.getCondition().get("sessionLoginCode"));
        List<WfiSignTask> taskPools = this.echainJoinService.selectUserSignTasks(model);
        return new ResultDto(taskPools);
    }

    @GetMapping(value={"/getUserSignVotes"})
    public ResultDto<List<EchainJoinSignVoteDTO>> getUserSignVotes(QueryModel model) {
        model.getCondition().put("loginCode", "" + model.getCondition().get("sessionLoginCode"));
        List<EchainJoinSignVoteDTO> votes = this.echainJoinService.selectUserSignVotes(model);
        return new ResultDto(votes);
    }

    @GetMapping(value={"/getUserAnnounce"})
    public ResultDto<List<EchainJoinWorkTodoDTO>> selectUserAnnounce(QueryModel model) {
        model.getCondition().put("loginCode", "" + model.getCondition().get("sessionLoginCode"));
        List<EchainJoinWorkTodoDTO> todos = this.echainJoinService.selectUserAnnounce(model);
        return new ResultDto(todos);
    }
}

