/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.echain.server.service;

import cn.com.yusys.yusp.commons.mapper.QueryModel;
import cn.com.yusys.yusp.echain.client.dto.core.EchainInstanceDTO;
import cn.com.yusys.yusp.echain.client.sign.SignConfigInterface;
import cn.com.yusys.yusp.echain.client.sign.impl.SignConfigImpl;
import cn.com.yusys.yusp.echain.server.domain.AdminSmOrg;
import cn.com.yusys.yusp.echain.server.domain.WfHumanstates;
import cn.com.yusys.yusp.echain.server.domain.WfiSignConf;
import cn.com.yusys.yusp.echain.server.domain.WfiSignTask;
import cn.com.yusys.yusp.echain.server.domain.WfiSignVote;
import cn.com.yusys.yusp.echain.server.domain.WfiWorkflowBiz;
import cn.com.yusys.yusp.echain.server.domain.WfiWorkflowNode;
import cn.com.yusys.yusp.echain.server.domain.WfiWorkflowOrg;
import cn.com.yusys.yusp.echain.server.domain.dto.EchainJoinInstanceDTO;
import cn.com.yusys.yusp.echain.server.domain.dto.EchainJoinSignVoteDTO;
import cn.com.yusys.yusp.echain.server.domain.dto.EchainJoinSubmitResultDTO;
import cn.com.yusys.yusp.echain.server.domain.dto.EchainJoinUserInfoDTO;
import cn.com.yusys.yusp.echain.server.repository.mapper.EchainJoinCoreMapper;
import cn.com.yusys.yusp.echain.server.repository.mapper.WfiSignConfMapper;
import cn.com.yusys.yusp.echain.server.repository.mapper.WfiSignTaskMapper;
import cn.com.yusys.yusp.echain.server.repository.mapper.WfiSignVoteMapper;
import com.ecc.echain.util.UNIDProducer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageHelper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EchainJoinCoreService {
    private static final Logger log = LoggerFactory.getLogger(EchainJoinCoreService.class);
    private ObjectMapper jsonMapper = new ObjectMapper();
    public static final String SIGN_DATA_PATTERN = "yyyy-MM-dd";
    @Autowired
    private EchainJoinCoreMapper echainJoinCoreMapper;
    @Autowired
    private WfiSignTaskMapper wfiSignTaskMapper;
    @Autowired
    private WfiSignVoteMapper wfiSignVoteMapper;
    @Autowired
    private WfiSignConfMapper wfiSignConfMapper;

    public String queryWfSignByBiz(String applType, String orgCode, String instuCde) {
        String wfSign = null;
        List<WfiWorkflowBiz> bizConfigs = this.echainJoinCoreMapper.selectWfiWorkflowBizByApplType(applType);
        if (bizConfigs == null || bizConfigs.isEmpty()) {
            wfSign = null;
        } else if (bizConfigs.size() == 1) {
            wfSign = bizConfigs.get(0).getWfsign();
        } else {
            String orgCodeTmp = orgCode;
            while (true) {
                WfiWorkflowOrg orgConfig;
                if ((orgConfig = this.echainJoinCoreMapper.selectWfiWorkflowOrgByApplType(applType, instuCde, orgCodeTmp)) != null) {
                    wfSign = orgConfig.getWfsign();
                    break;
                }
                AdminSmOrg org = this.echainJoinCoreMapper.selectAdminSmOrgUpOrg(instuCde, orgCodeTmp);
                if (org == null) {
                    orgCodeTmp = null;
                    break;
                }
                orgCodeTmp = org.getOrgCode();
            }
        }
        return wfSign;
    }

    public String queryFuncIdByBiz(String applType, String wfSign, String nodeId) {
        List<WfiWorkflowNode> workflowNodes = this.echainJoinCoreMapper.selectWfiWorkflowNodeByNodeId(applType, wfSign, nodeId);
        if (workflowNodes != null && !workflowNodes.isEmpty()) {
            return workflowNodes.get(0).getFuncId();
        }
        List<WfiWorkflowBiz> workflowBizs = this.echainJoinCoreMapper.selectWfiWorkflowBizByWfSign(applType, wfSign);
        if (workflowBizs != null && !workflowBizs.isEmpty()) {
            return workflowBizs.get(0).getFuncId();
        }
        return null;
    }

    public List<EchainJoinUserInfoDTO> getJumpUsersByModel(QueryModel query) {
        PageHelper.startPage((int)query.getPage(), (int)query.getSize());
        List<EchainJoinUserInfoDTO> list = this.echainJoinCoreMapper.selectJumpUsersByModel(query);
        PageHelper.clearPage();
        return list;
    }

    public List<EchainJoinUserInfoDTO> getAssistUsersByModel(QueryModel query) {
        PageHelper.startPage((int)query.getPage(), (int)query.getSize());
        List<EchainJoinUserInfoDTO> list = this.echainJoinCoreMapper.selectAssistUsersByModel(query);
        PageHelper.clearPage();
        return list;
    }

    public List<WfHumanstates> getAgentOfValidity(String sysId, String loginCode, String currentTime, String applType) {
        return this.echainJoinCoreMapper.selectAgentOfValidity(sysId, loginCode, currentTime, applType);
    }

    public WfiSignTask selectSignTaskInfo(String stTaskId) {
        return this.wfiSignTaskMapper.selectByPrimaryKey(stTaskId);
    }

    public List<EchainJoinUserInfoDTO> selectSignTaskUsersByModel(QueryModel query) {
        PageHelper.startPage((int)query.getPage(), (int)query.getSize());
        List<EchainJoinUserInfoDTO> users = this.echainJoinCoreMapper.selectSignTaskUsersByModel(query);
        PageHelper.clearPage();
        return users;
    }

    public WfiSignTask initSignTask(WfiSignTask task, String nodeName, String nodeUsersList) {
        UNIDProducer unidProducer = new UNIDProducer();
        SimpleDateFormat sdf = new SimpleDateFormat(SIGN_DATA_PATTERN);
        task.setStTaskId(unidProducer.getUNID());
        task.setStStartTime(sdf.format(new Date()));
        task.setStTotalCount(0);
        task.setStAgreeCount(0);
        task.setStVoteCount(0);
        task.setStRejectCount(0);
        task.setStNoideaCount(0);
        task.setWfiBizPage("/");
        String taskName = nodeName + "(1)";
        String stDuty = nodeUsersList.replaceAll("G\\.", "").replaceAll(";", ",");
        task.setStDuty(stDuty);
        task.setStTaskName(taskName);
        task.setStTaskStatus("210");
        task.setStTaskTimes(1);
        this.wfiSignTaskMapper.insert(task);
        return task;
    }

    public int saveSignTaskInfo(WfiSignTask record) {
        return this.wfiSignTaskMapper.updateByPrimaryKey(record);
    }

    public boolean beginSignTask(String stTaskId) {
        boolean success = false;
        WfiSignTask wfiSignTask = this.wfiSignTaskMapper.selectByPrimaryKey(stTaskId);
        if (wfiSignTask != null) {
            String voteUserStr = wfiSignTask.getStMembers();
            String currentTime = new SimpleDateFormat(SIGN_DATA_PATTERN).format(new Date());
            int i = 0;
            for (String user : voteUserStr.split(",")) {
                ++i;
                if ("".equals(user)) continue;
                WfiSignVote vote = new WfiSignVote();
                String voteId = new UNIDProducer().getUNID();
                vote.setSvVoteId(voteId);
                vote.setStTaskId(stTaskId);
                vote.setSvExeUser(user);
                vote.setSvStartTime(currentTime);
                vote.setSvResult(null);
                vote.setSvStatus("211");
                this.wfiSignVoteMapper.insert(vote);
            }
            wfiSignTask.setStTotalCount(i);
            wfiSignTask.setStTaskStatus("212");
            this.wfiSignTaskMapper.updateByPrimaryKey(wfiSignTask);
            success = true;
        }
        return success;
    }

    public WfiSignTask reBeginSignTask(String stTaskId) {
        WfiSignTask task = this.wfiSignTaskMapper.selectByPrimaryKey(stTaskId);
        String currentTime = new SimpleDateFormat(SIGN_DATA_PATTERN).format(new Date());
        task.setStEndTime(currentTime);
        task.setStResult("112");
        task.setStTaskStatus("214");
        this.wfiSignTaskMapper.updateByPrimaryKey(task);
        int taskTimes = task.getStTaskTimes();
        String stTaskName = task.getStTaskName();
        String taskName = stTaskName.replaceAll("\\d+(?=\\))", String.valueOf(++taskTimes));
        task.setStTaskId(null);
        task.setStTaskName(taskName);
        task.setStStartTime(currentTime);
        task.setStEndTime("");
        task.setStAdvice("");
        task.setStTotalCount(0);
        task.setStVoteCount(0);
        task.setStAgreeCount(0);
        task.setStRejectCount(0);
        task.setStNoideaCount(0);
        task.setStLeader("");
        task.setStMembers("");
        task.setStResult("");
        task.setStTaskTimes(taskTimes);
        task.setStTaskStatus("210");
        task.setStTaskId(new UNIDProducer().getUNID());
        this.wfiSignTaskMapper.insert(task);
        return task;
    }

    public boolean finishSignTask(String stTaskId) {
        boolean success = false;
        WfiSignTask task = this.wfiSignTaskMapper.selectByPrimaryKey(stTaskId);
        if (task != null) {
            String currentTime = new SimpleDateFormat(SIGN_DATA_PATTERN).format(new Date());
            QueryModel queryModel = new QueryModel();
            queryModel.getCondition().put("stStakId", stTaskId);
            List<WfiSignVote> voteList = this.echainJoinCoreMapper.selectSignTaskVotesByModel(queryModel);
            task.setStResult("112");
            for (WfiSignVote vote : voteList) {
                if (vote.getSvResult() != null) continue;
                vote.setSvEndTime(currentTime);
                vote.setSvStatus("215");
                this.wfiSignVoteMapper.updateByPrimaryKeySelective(vote);
            }
            task.setStTaskStatus("213");
            task.setStEndTime(currentTime);
            this.wfiSignTaskMapper.updateByPrimaryKey(task);
            success = true;
        }
        return success;
    }

    public WfiSignTask cancleSignTask(String stTaskId) {
        WfiSignTask task = this.wfiSignTaskMapper.selectByPrimaryKey(stTaskId);
        if (task != null) {
            String currentTime = new SimpleDateFormat(SIGN_DATA_PATTERN).format(new Date());
            QueryModel queryModel = new QueryModel();
            queryModel.getCondition().put("stStakId", stTaskId);
            List<WfiSignVote> voteList = this.echainJoinCoreMapper.selectSignTaskVotesByModel(queryModel);
            for (WfiSignVote vote : voteList) {
                if (vote.getSvResult() != null) continue;
                vote.setSvEndTime(currentTime);
                vote.setSvStatus("215");
                this.wfiSignVoteMapper.updateByPrimaryKeySelective(vote);
            }
            task.setStTaskStatus("216");
            task.setStEndTime(currentTime);
            this.wfiSignTaskMapper.updateByPrimaryKey(task);
        }
        return task;
    }

    public WfiSignTask endSignTask(String stTaskId) {
        WfiSignTask task = this.wfiSignTaskMapper.selectByPrimaryKey(stTaskId);
        if (task != null) {
            String result = task.getStResult();
            result = result.equals("110") ? "10" : "20";
            String commentId = new UNIDProducer().getUNID();
            task.setWfiAdviceId(commentId);
            task.setStTaskStatus("217");
            this.wfiSignTaskMapper.updateByPrimaryKey(task);
        }
        return task;
    }

    public void updateWf4Sign(String stTaskId) {
        WfiSignTask task = this.wfiSignTaskMapper.selectByPrimaryKey(stTaskId);
        this.echainJoinCoreMapper.updateWfNodeRecord4Sign(task.getWfiNodeId(), task.getWfiInstanceId(), "signUser", task.getStExeUser());
        this.echainJoinCoreMapper.updateWfInstanceNodeProperty4Sign(task.getWfiNodeId(), task.getWfiInstanceId(), "signUser", task.getStExeUser());
        this.echainJoinCoreMapper.deleteWfInstanceNodeUser(task.getWfiNodeId(), task.getWfiInstanceId(), task.getStExeUser());
        this.echainJoinCoreMapper.deleteWfInstanceNodeUsers(task.getWfiNodeId(), task.getWfiInstanceId(), task.getStExeUser());
        this.echainJoinCoreMapper.updateWfInstanceNodeUser4Sign(task.getWfiNodeId(), task.getWfiInstanceId(), "signUser", task.getStExeUser());
        this.echainJoinCoreMapper.updateWfInstanceNodeUsers4Sign(task.getWfiNodeId(), task.getWfiInstanceId(), "signUser", task.getStExeUser());
    }

    public List<EchainJoinSignVoteDTO> selectSignTaskVoteInfosByModel(QueryModel query) {
        PageHelper.startPage((int)query.getPage(), (int)query.getSize());
        List<EchainJoinSignVoteDTO> list = this.echainJoinCoreMapper.selectSignTaskVoteInfosByModel(query);
        PageHelper.clearPage();
        return list;
    }

    public EchainJoinSignVoteDTO selectSignVoteInfo(String svVoteId) {
        return this.echainJoinCoreMapper.selectUserSignVoteById(svVoteId);
    }

    public boolean submitSignVote(String voteId, String result, String svAdvice) {
        WfiSignVote vote = null;
        WfiSignTask task = null;
        boolean success = false;
        try {
            String currentTime = new SimpleDateFormat(SIGN_DATA_PATTERN).format(new Date());
            vote = this.wfiSignVoteMapper.selectByPrimaryKey(voteId);
            task = this.wfiSignTaskMapper.selectByPrimaryKey(vote.getStTaskId());
            String oldResult = vote.getSvResult();
            vote.setSvStatus("213");
            vote.setSvAdvice(svAdvice);
            vote.setSvResult(result);
            vote.setSvEndTime(currentTime);
            this.wfiSignVoteMapper.updateByPrimaryKey(vote);
            this.calculationVote(task, result, oldResult);
            QueryModel queryModel = new QueryModel();
            queryModel.getCondition().put("stStakId", vote.getStTaskId());
            List<WfiSignVote> voteList = this.echainJoinCoreMapper.selectSignTaskVotesByModel(queryModel);
            boolean finishTask = this.calculationSignConfig(task, voteList, currentTime);
            if (finishTask) {
                for (WfiSignVote obj : voteList) {
                    if (obj.getSvResult() != null) continue;
                    obj.setSvEndTime(currentTime);
                    obj.setSvStatus("215");
                    this.wfiSignVoteMapper.updateByPrimaryKey(obj);
                }
                task.setStTaskStatus("213");
            }
            this.wfiSignTaskMapper.updateByPrimaryKey(task);
            success = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return success;
    }

    public Long selectWfAsynSubCount(String instanceId, String nodeId) {
        return this.echainJoinCoreMapper.selectWfAsynSubCount(instanceId, nodeId);
    }

    private boolean calculationSignConfig(WfiSignTask task, List<WfiSignVote> voteList, String openDay) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String leader;
        double noIdeaCount;
        double rejectCount;
        double agreeCount;
        double voteCount;
        double totalCount;
        boolean success = false;
        WfiSignConf conf = null;
        String signConfigId = task.getStConfig();
        conf = this.wfiSignConfMapper.selectByPrimaryKey(signConfigId);
        String confClassName = SignConfigImpl.class.getName();
        if (conf != null) {
            confClassName = conf.getSignClass();
        }
        HashMap<String, String> voteMap = new HashMap<String, String>();
        HashMap<String, String> voteAdviceMap = new HashMap<String, String>();
        for (WfiSignVote vote : voteList) {
            voteMap.put(vote.getSvExeUser(), vote.getSvResult());
            voteAdviceMap.put(vote.getSvExeUser(), vote.getSvAdvice());
        }
        SignConfigInterface imp = (SignConfigInterface)Class.forName(confClassName).newInstance();
        String result = imp.checkSignTaskResult(totalCount = (double)task.getStTotalCount().intValue(), voteCount = (double)task.getStVoteCount().intValue(), agreeCount = (double)task.getStAgreeCount().intValue(), rejectCount = (double)task.getStRejectCount().intValue(), noIdeaCount = (double)task.getStNoideaCount().intValue(), voteMap, leader = task.getStLeader());
        success = EchainJoinCoreService.isValidResult(result);
        if (success) {
            String stAdvice = imp.buildSignAdviceResult(totalCount, voteCount, agreeCount, rejectCount, noIdeaCount, voteAdviceMap, leader);
            if (stAdvice != null) {
                task.setStAdvice(stAdvice);
            }
            task.setStResult(result);
            task.setStTaskStatus("213");
            task.setStEndTime(openDay);
        }
        return success;
    }

    private static boolean isValidResult(String result) {
        return "110".equals(result) || "111".equals(result) || "112".equals(result);
    }

    private void calculationVote(WfiSignTask task, String newResult, String oldResult) {
        if (oldResult == null) {
            if (newResult != null) {
                task.setStVoteCount(task.getStVoteCount() + 1);
            }
        } else if (oldResult.equals("110")) {
            task.setStAgreeCount(task.getStAgreeCount() - 1);
        } else if (oldResult.equals("111")) {
            task.setStRejectCount(task.getStRejectCount() - 1);
        } else if (oldResult.equals("112")) {
            task.setStNoideaCount(task.getStNoideaCount() - 1);
        }
        if (newResult == null) {
            if (oldResult != null) {
                task.setStVoteCount(task.getStVoteCount() - 1);
            }
        } else if (newResult.equals("110")) {
            task.setStAgreeCount(task.getStAgreeCount() + 1);
        } else if (newResult.equals("111")) {
            task.setStRejectCount(task.getStRejectCount() + 1);
        } else if (newResult.equals("112")) {
            task.setStNoideaCount(task.getStNoideaCount() + 1);
        }
    }

    public EchainJoinSubmitResultDTO buildSubmitResult(EchainInstanceDTO info) {
        this.logEchainResult(info);
        EchainJoinSubmitResultDTO rtDto = new EchainJoinSubmitResultDTO();
        BeanUtils.copyProperties((Object)info, (Object)rtDto);
        return rtDto;
    }

    public EchainJoinInstanceDTO buildInstanceResult(EchainInstanceDTO info) {
        String actionKey = "getNodeControlFormAction";
        this.logEchainResult(info);
        EchainJoinInstanceDTO rtDto = new EchainJoinInstanceDTO();
        BeanUtils.copyProperties((Object)info, (Object)rtDto);
        rtDto.setApplType(info.getAppId());
        HashMap<String, String> actionMap = new HashMap<String, String>();
        HashMap paramMap = info.getParamMap();
        if (paramMap != null && paramMap.containsKey(actionKey)) {
            Map formAction = (Map)paramMap.get(actionKey);
            Set keySet = formAction.keySet();
            for (Object key : keySet) {
                Object value = formAction.get(key);
                if (value == null) continue;
                actionMap.put(key.toString(), value.toString());
            }
        }
        rtDto.setAction(actionMap);
        String extKey = "getWFNodeExtProperties";
        HashMap<String, String> extMap = new HashMap<String, String>();
        HashMap extParamMap = info.getParamMap();
        if (extParamMap != null && extParamMap.containsKey(extKey)) {
            Map extActions = (Map)extParamMap.get(extKey);
            Set keySet = extActions.keySet();
            for (Object key : keySet) {
                Object value = extActions.get(key);
                if (value == null) continue;
                extMap.put(key.toString(), value.toString());
            }
        }
        rtDto.setExt(extMap);
        return rtDto;
    }

    private void logEchainResult(EchainInstanceDTO instanceInfo) {
        try {
            if (log.isDebugEnabled()) {
                String str = this.jsonMapper.writeValueAsString((Object)instanceInfo);
                log.debug(str);
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }
}

