/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.echain.server.service;

import cn.com.yusys.yusp.commons.mapper.QueryModel;
import cn.com.yusys.yusp.echain.server.domain.AdminSmUser;
import cn.com.yusys.yusp.echain.server.domain.WfHumanstates;
import cn.com.yusys.yusp.echain.server.repository.mapper.WfAdminSmUserMapper;
import cn.com.yusys.yusp.echain.server.repository.mapper.WfHumanstatesMapper;
import com.ecc.echain.workflow.cache.WFClientInstuCache;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EchainJoinAgentService {
    public static final String SYSID_KEY = "sysid";
    @Autowired
    private WfHumanstatesMapper wfHumanstatesMapper;
    @Autowired
    private WfAdminSmUserMapper adminSmUserMapper;

    public Boolean addWfHumanstates(String instuCde, WfHumanstates record) {
        record.setSysid(this.getSysidByRealInstuCde(instuCde));
        int insert = this.wfHumanstatesMapper.insertSelective(record);
        return insert > 0;
    }

    public Boolean deleteWFHumanstates(String pkey) {
        int deleteByPrimaryKey = this.wfHumanstatesMapper.deleteByPrimaryKey(pkey);
        return deleteByPrimaryKey > 0;
    }

    public Boolean updateWFHumanstates(WfHumanstates record) {
        int updateByPrimaryKey = this.wfHumanstatesMapper.updateByPrimaryKeySelective(record);
        return updateByPrimaryKey > 0;
    }

    public List<WfHumanstates> queryWFHumanstatesList(String instuCde, QueryModel queryModel) {
        queryModel.getCondition().put(SYSID_KEY, this.getSysidByRealInstuCde(instuCde));
        PageHelper.startPage((int)queryModel.getPage(), (int)queryModel.getSize());
        List<WfHumanstates> list = this.wfHumanstatesMapper.selectHumanstatsList(queryModel);
        PageHelper.clearPage();
        return list;
    }

    public List<AdminSmUser> queryAllUsrsByParamForPop(String orgId, QueryModel queryModel) {
        queryModel.getCondition().put("orgId", orgId);
        PageHelper.startPage((int)queryModel.getPage(), (int)queryModel.getSize());
        List<AdminSmUser> list = this.adminSmUserMapper.selectAllUsrsByParamForPop(queryModel);
        PageHelper.clearPage();
        return list;
    }

    public List<WfHumanstates> queryWfHumanstatsByTime(QueryModel model) {
        List<WfHumanstates> list = this.wfHumanstatesMapper.selectWfHumanstatsByTime(model);
        return list;
    }

    protected String getSysidByRealInstuCde(String realInstuCde) {
        String clientSign = WFClientInstuCache.getInstance().getClientSign(realInstuCde);
        return clientSign;
    }
}

