/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.echain.server.message;

import cn.com.yusys.yusp.echain.client.dto.core.EchainInstanceDTO;
import cn.com.yusys.yusp.echain.client.message.InstanceMessage;
import cn.com.yusys.yusp.echain.server.service.EchainCoreMessageService;
import cn.com.yusys.yusp.echain.server.util.EchainVOUtils;
import com.ecc.echain.workflow.engine.EVO;
import com.ecc.echain.workflow.engine.WorkFlowClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;

public class MQEchainCoreMessageService
implements EchainCoreMessageService {
    private final Logger log = LoggerFactory.getLogger(EchainCoreMessageService.class);
    @Autowired
    private AmqpTemplate amqpTemplate;
    private ObjectMapper mapper = new ObjectMapper();
    private WorkFlowClient wfc = WorkFlowClient.getInstance();

    @Override
    public boolean sendMessage(String type, boolean success, EVO requestEVO) {
        EVO paramEVO = new EVO();
        paramEVO.setInstanceID(requestEVO.getInstanceID());
        String message = null;
        try {
            EVO instanceEVO = this.wfc.getInstanceInfo(paramEVO);
            EchainInstanceDTO instanceInfo = EchainVOUtils.evo2InstanceDTO(instanceEVO);
            instanceInfo.setParamMap(requestEVO.paramMap);
            this.log.debug("Echain\u540e\u4e1a\u52a1\u5904\u7406[\u9636\u6bb5" + type + ",\u6d41\u7a0b\u540d\u79f0\uff1a" + instanceInfo.getJobName() + ",\u5b9e\u4f8bid:" + instanceInfo.getInstanceId() + ",\u8282\u70b9id:" + instanceInfo.getNodeId() + "]");
            InstanceMessage instanceMessage = new InstanceMessage(type, success, instanceInfo);
            message = this.mapper.writeValueAsString((Object)instanceMessage);
            this.amqpTemplate.convertAndSend("echain." + instanceEVO.getWFSign(), (Object)message);
            return true;
        }
        catch (Exception e) {
            this.log.error("Echain\u670d\u52a1\u7aefQueue\u6d88\u606f\u53d1\u9001\u5f02\u5e38: " + e + "\n\u6d88\u606f\u4e3a: " + message);
            return false;
        }
    }
}

