/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.echain.server.echain.organization;

import cn.com.yusys.yusp.echain.server.echain.EChainRuntimeContext;
import cn.com.yusys.yusp.echain.server.echain.organization.SqlUtil;
import com.ecc.echain.org.OrgIF;
import com.ecc.echain.org.model.DepModel;
import com.ecc.echain.org.model.GroupModel;
import com.ecc.echain.org.model.OrgModel;
import com.ecc.echain.org.model.RoleModel;
import com.ecc.echain.org.model.UserModel;
import com.ecc.echain.workflow.cache.OUCache;
import com.ecc.echain.workflow.model.WFClient;
import com.yucheng.cmis.pub.MD5;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisOrgImpl
implements OrgIF {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmisOrgImpl.class);

    public OrgModel getRootOrg(Connection con) {
        return null;
    }

    public List getAllBaseOrgs(Connection con) {
        ArrayList<OrgModel> list = new ArrayList<OrgModel>();
        OrgModel orgModel = null;
        orgModel = new OrgModel();
        orgModel.setOrgid("cmis");
        orgModel.setOrgname("\u4fe1\u8d37\u7cfb\u7edf\u7f3a\u7701\u673a\u6784");
        orgModel.setOrglevel(1);
        orgModel.setSuporgid("");
        list.add(orgModel);
        return list;
    }

    public List getDirectSubOrgs(String orgid, Connection con) {
        ArrayList<OrgModel> list = new ArrayList<OrgModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT * FROM S_BCH WHERE instu_cde = ? and BCH_SUP_CDE= ?");
            ps.setString(1, instuCde);
            ps.setString(2, orgid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (datas != null) {
                for (Map<String, String> org : datas) {
                    OrgModel orgModel = this.toOrgModel(org);
                    list.add(orgModel);
                }
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return list;
    }

    public List getAllSubOrgs(String orgid, Connection con) {
        ArrayList<OrgModel> list = new ArrayList<OrgModel>();
        try {
            PreparedStatement ps = con.prepareStatement("SELECT * FROM (SELECT * FROM S_BCH START WITH BCH_CDE= ? CONNECT BY NOCYCLE PRIOR BCH_CDE=BCH_SUP_CDE) WHERE BCH_CDE!= ?");
            ps.setString(1, orgid);
            ps.setString(2, orgid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> org : datas) {
                    OrgModel orgModel = this.toOrgModel(org);
                    list.add(orgModel);
                }
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return list;
    }

    public OrgModel getParentOrg(String orgid, Connection con) {
        OrgModel supOrgModel = null;
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT * FROM S_BCH WHERE BCH_CDE=(SELECT BCH_SUP_CDE FROM S_BCH WHERE INSTU_CDE= ? AND BCH_CDE= ?)");
            ps.setString(1, instuCde);
            ps.setString(2, orgid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (null != datas && !datas.isEmpty()) {
                supOrgModel = this.toOrgModel(datas.get(0));
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return supOrgModel;
    }

    public OrgModel getOrgModel(String orgid, Connection con) {
        OrgModel model = new OrgModel();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT * FROM S_BCH WHERE BCH_CDE = ? and INSTU_CDE = ?");
            ps.setString(2, instuCde);
            ps.setString(1, orgid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (null != datas && !datas.isEmpty()) {
                model = this.toOrgModel(datas.get(0));
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return model;
    }

    public List getAllOrgs(Connection con) {
        ArrayList<OrgModel> list = new ArrayList<OrgModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT * FROM S_BCH where instu_cde = ? order by bch_level,bch_cde ");
            ps.setString(1, instuCde);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> org : datas) {
                    OrgModel orgModel = this.toOrgModel(org);
                    list.add(orgModel);
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return list;
    }

    public List getDirectDepsByOrg(String orgid, Connection con) {
        return new ArrayList();
    }

    public List getAllDepsByOrg(String orgid, Connection con) {
        return new ArrayList();
    }

    public List getDirectSubDepsByDep(String orgid, String depid, Connection con) {
        return new ArrayList();
    }

    public List getAllSubDepsByDep(String orgid, String depid, Connection con) {
        return new ArrayList();
    }

    public DepModel getParentDep(String orgid, String depid, Connection con) {
        return null;
    }

    public DepModel getDepModel(String orgid, String depid, Connection con) {
        return null;
    }

    public List getDirectUsersByOrg(String orgid, Connection con) {
        ArrayList<UserModel> list = new ArrayList<UserModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("select USR_CDE,USR_NAME,USR_EMAIL,USR_TEL,USR_BCH from S_USR where instu_cde = ? and USR_BCH= ?");
            ps.setString(1, instuCde);
            ps.setString(2, orgid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> user : datas) {
                    UserModel userModel = this.toUserModel(user);
                    list.add(userModel);
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getAllUsersByOrg(String orgid, Connection con) {
        ArrayList<UserModel> list = new ArrayList<UserModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("select USR_CDE,USR_NAME,USR_EMAIL,USR_TEL,USR_BCH from S_USR where instu_cde = ? and USR_BCH= ?");
            ps.setString(1, instuCde);
            ps.setString(2, orgid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> user : datas) {
                    UserModel userModel = this.toUserModel(user);
                    list.add(userModel);
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getDirectUsersByDep(String orgid, String depid, Connection con) {
        return new ArrayList();
    }

    public List getAllUsersByDep(String orgid, String depid, Connection con) {
        return new ArrayList();
    }

    public UserModel getUserModel(String orgid, String userid, Connection con) {
        return this.getUserModel(userid, con);
    }

    public UserModel getUserModel(String userid, Connection con) {
        UserModel userModel = null;
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT USR_CDE,USR_NAME,USR_EMAIL,USR_TEL,USR_BCH FROM S_USR WHERE INSTU_CDE = ? AND USR_CDE = ?");
            ps.setString(1, instuCde);
            ps.setString(2, userid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                userModel = this.toUserModel(datas.get(0));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return userModel;
    }

    public String getOrgIdByUser(String userid, Connection con) {
        String orgid = null;
        if (this.getSignUser().equals(userid) || userid.startsWith("T.")) {
            return orgid;
        }
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT USR_CDE,USR_NAME,USR_EMAIL,USR_TEL,USR_BCH FROM S_USR WHERE INSTU_CDE = ? AND USR_CDE = ?");
            ps.setString(1, instuCde);
            ps.setString(2, userid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                orgid = datas.get(0).get("USR_BCH");
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return orgid;
    }

    public UserModel isValidUser(String orgid, String userid, String password, Connection con) {
        UserModel model = null;
        String instuCde = this.getCurrentInstuCde();
        List<Object> datas = new ArrayList();
        try {
            PreparedStatement ps = con.prepareStatement("SELECT USR_CDE,USR_NAME,USR_EMAIL,USR_TEL,USR_BCH ,USR_PASSWORD FROM S_USR WHERE INSTU_CDE = ? AND USR_CDE = ?");
            ps.setString(1, instuCde);
            ps.setString(2, userid);
            ResultSet rs = ps.executeQuery();
            datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (datas != null && !datas.isEmpty()) {
            new MD5();
            password = MD5.getMD5ofStr((String)(userid + password));
            if (password.equals(((Map)datas.get(0)).get("USR_PASSWORD"))) {
                model = this.toUserModel((Map)datas.get(0));
                model.setUserstatus(1);
                model.setAdminflag(true);
                model.setWfadminflag(true);
                model.setSaflag(true);
                model.setPassword(password);
            }
        }
        return model;
    }

    public List getOrgLeaders(String orgid, Connection con) {
        return new ArrayList();
    }

    public List getOrgDirectors(String orgid, Connection con) {
        return new ArrayList();
    }

    public List getDepLeaders(String orgid, String depid, Connection con) {
        return new ArrayList();
    }

    public List getDepDirectors(String orgid, String depid, Connection con) {
        return new ArrayList();
    }

    public List getAllBaseRoles(Connection con) {
        return this.getAllRoles(con);
    }

    public List getAllRoles(Connection con) {
        return this.getAllRoles(null, con);
    }

    public List getAllRoles(String orgid, Connection con) {
        ArrayList<RoleModel> list = new ArrayList<RoleModel>();
        String instuCde = this.getCurrentInstuCde();
        try {
            PreparedStatement ps = con.prepareStatement("select  s.ROLE_CDE,s.ROLE_NAME,s.ROLE_STS,s.ROLE_RMK,s.INSTU_CDE from s_role s where s.instu_cde = ? ");
            ps.setString(1, instuCde);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> role : datas) {
                    RoleModel model = this.toRoleModel(role);
                    list.add(model);
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getRolesByName(String orgid, String roleName, Connection con) {
        ArrayList<RoleModel> list = new ArrayList<RoleModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT * FROM S_ROLE WHERE role_name LIKE ?");
            ps.setString(1, "%" + roleName + "%");
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> role : datas) {
                    RoleModel roleModel = this.toRoleModel(role);
                    list.add(roleModel);
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getAllRoles(String orgid, String depid, Connection con) {
        return this.getAllRoles(null, con);
    }

    public RoleModel getRoleModel(String orgid, String roleid, Connection con) {
        RoleModel result = null;
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT * FROM S_ROLE WHERE role_cde = ?");
            ps.setString(1, roleid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                result = this.toRoleModel(datas.get(0));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public List getUsersByRole(String orgid, String roleid, Connection con) {
        ArrayList<UserModel> list = new ArrayList<UserModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("select * from S_USR a, s_usr_role b where a.instu_cde=b.instu_cde and a.usr_cde = b.usr_cde and b.role_cde= ? and b.instu_cde = ?");
            ps.setString(1, roleid);
            ps.setString(2, instuCde);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> user : datas) {
                    UserModel userModel = this.toUserModel(user);
                    list.add(userModel);
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getRolesByUser(String orgid, String userid, Connection con) {
        ArrayList<RoleModel> list = new ArrayList<RoleModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("select s.ROLE_CDE,s.ROLE_NAME,s.ROLE_STS,s.ROLE_RMK,s.INSTU_CDE from s_role s, S_USR_ROLE u  where s.ROLE_CDE = u.ROLE_CDE and u.USR_CDE= ? and u.instu_cde = ?");
            ps.setString(1, userid);
            ps.setString(2, instuCde);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> role : datas) {
                    RoleModel model = this.toRoleModel(role);
                    list.add(model);
                }
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getAllBaseGroups(Connection con) {
        return this.getAllGroups(con);
    }

    public List getAllGroups(Connection con) {
        ArrayList<GroupModel> list = new ArrayList<GroupModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT * FROM S_DUTY");
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (datas != null && !datas.isEmpty()) {
                for (int i = 0; i < datas.size(); ++i) {
                    GroupModel groupmodel = this.toGroupModel(datas.get(i));
                    list.add(groupmodel);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getAllGroups(String orgid, Connection con) {
        ArrayList<GroupModel> list = new ArrayList<GroupModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT DUTY_CDE,DUTY_DESC FROM S_DUTY WHERE INSTU_CDE= ?");
            ps.setString(1, instuCde);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (datas != null && !datas.isEmpty()) {
                for (int i = 0; i < datas.size(); ++i) {
                    Map<String, String> duty = datas.get(i);
                    GroupModel groupmodel = this.toGroupModel(duty);
                    list.add(groupmodel);
                }
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return list;
    }

    public List getAllGroups(String orgid, String depid, Connection con) {
        return this.getAllGroups(orgid, con);
    }

    public GroupModel getGroupModel(String orgid, String groupid, Connection con) {
        GroupModel groupModel = null;
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT DUTY_CDE,DUTY_DESC FROM S_DUTY WHERE duty_cde= ?");
            ps.setString(1, groupid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (datas != null && !datas.isEmpty()) {
                groupModel = this.toGroupModel(datas.get(0));
                groupModel.setOrgid(this.getWfiCmisOrgId());
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return groupModel;
    }

    public List getUsersByGroup(String orgid, String groupid, Connection con) {
        ArrayList<UserModel> list = new ArrayList<UserModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT A.* FROM S_USR A ,S_USR_DUTY B WHERE A.INSTU_CDE=B.INSTU_CDE AND A.USR_CDE = B.USR_CDE AND A.INSTU_CDE= ? AND B.DUTY_CDE=?");
            ps.setString(1, instuCde);
            ps.setString(2, groupid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> user : datas) {
                    list.add(this.toUserModel(user));
                }
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return list;
    }

    public List getGroupByUser(String orgid, String userid, Connection con) {
        ArrayList<GroupModel> list = new ArrayList<GroupModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("select * from s_duty a ,s_usr_duty b where a.DUTY_CDE = b.DUTY_CDE and b.USR_CDE= ? ");
            ps.setString(1, userid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> duty : datas) {
                    GroupModel groupModel = this.toGroupModel(duty);
                    list.add(groupModel);
                }
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return list;
    }

    public String getGrantor(String orgid, String userid, String appid, Connection con) {
        return null;
    }

    public List getSuperiorUsers(String orgid, String userid, Connection con) {
        List list = new ArrayList();
        try {
            String instuCde = this.getCurrentInstuCde();
            OrgModel supOrg = this.getParentOrg(orgid, con);
            if (supOrg == null) {
                return list;
            }
            String supOrgId = supOrg.getOrgid();
            if (supOrgId != null && !supOrgId.equals(orgid)) {
                list = this.getDirectUsersByOrg(supOrgId, con);
            }
        }
        catch (Exception e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
        }
        return list;
    }

    public List getJuniorUsers(String orgid, String userid, Connection con) {
        return new ArrayList();
    }

    public List getSameDepUsers(String orgid, String userid, Connection con) {
        return new ArrayList();
    }

    public List getSameOrgUsers(String orgid, String userid, Connection con) {
        List list = new ArrayList();
        try {
            String instuCde = this.getCurrentInstuCde();
            if (null != userid && userid.length() > 0) {
                UserModel userTmp = this.getUserModel(userid, con);
                orgid = userTmp.getOrgid();
            }
            list = this.getDirectUsersByOrg(orgid, con);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public String getUserEmail(String orgid, String userid, Connection con) {
        UserModel userModel = this.getUserModel(userid, con);
        String strResult = userModel.getEmail();
        return strResult;
    }

    public void loadOUCache(OUCache oucache, Connection con) {
        LOGGER.warn("\u4e0d\u4f7f\u7528\u7ec4\u7ec7\u673a\u6784\u7684jvm\u7f13\u5b58\uff0c\u4e0d\u505a\u7f13\u5b58\u52a0\u8f7d");
    }

    public List getAllWFClient(String status, Connection con) {
        ArrayList<WFClient> list = new ArrayList<WFClient>();
        WFClient client = null;
        try {
            String strSql = "select pkey,ClientSign,ClientName,IP,Type,InvokeType,Status,Remark from WF_CLIENT ";
            if (status != null && status.length() > 0) {
                strSql = strSql + " where status= ?";
            }
            PreparedStatement ps = con.prepareStatement(strSql);
            if (status != null && status.length() > 0) {
                ps.setString(1, status);
            }
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (datas != null && !datas.isEmpty()) {
                for (Map<String, String> wfClientTemp : datas) {
                    WFClient wfClient = new WFClient();
                    wfClient.setPkey(wfClientTemp.get("PKEY"));
                    wfClient.setClientSign(wfClientTemp.get("CLIENTSIGN"));
                    wfClient.setClientName(wfClientTemp.get("CLIENTNAME"));
                    wfClient.setIP(wfClientTemp.get("IP"));
                    wfClient.setType(wfClientTemp.get("TYPE"));
                    wfClient.setInvokeType(wfClientTemp.get("INVOKETYPE"));
                    wfClient.setStatus(wfClientTemp.get("STATUS"));
                    wfClient.setRemark(wfClientTemp.get("REMARK"));
                    list.add(wfClient);
                }
            } else {
                client = new WFClient();
                client.setPkey("");
                client.setClientSign("cmis");
                client.setClientName("\u4fe1\u8d37\u7ba1\u7406\u7cfb\u7edf");
                client.setIP("*.*.*.*");
                client.setType("");
                client.setInvokeType("1;2");
                client.setStatus("0");
                client.setRemark("");
                list.add(client);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List<UserModel> queryUserModelsByName(String name, Connection con) {
        ArrayList<UserModel> list = new ArrayList<UserModel>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT * FROM S_USR WHERE USR_NAME LIKE ?");
            ps.setString(1, "%" + name + "%");
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            for (Map<String, String> user : datas) {
                UserModel userModel = this.toUserModel(user);
                list.add(userModel);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getUpUpOrgUsers(String orgid, Connection con) {
        List list = new ArrayList();
        try {
            String instuCde = this.getCurrentInstuCde();
            OrgModel supOrg = this.getParentOrg(orgid, con);
            if (supOrg == null) {
                return list;
            }
            String supOrgNo = supOrg.getOrgid();
            OrgModel supSupOrg = this.getParentOrg(supOrgNo, con);
            if (supSupOrg == null) {
                return list;
            }
            String supSupOrgNo = supSupOrg.getOrgid();
            list = this.getDirectUsersByOrg(supSupOrgNo, con);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getUpUpOrgDownOrgUsers(String orgid, Connection con) {
        ArrayList list = new ArrayList();
        try {
            List subOrgList;
            String instuCde = this.getCurrentInstuCde();
            OrgModel supOrg = this.getParentOrg(orgid, con);
            if (supOrg == null) {
                return list;
            }
            OrgModel supSupOrg = this.getParentOrg(supOrg.getOrgid(), con);
            if (supSupOrg == null) {
                return list;
            }
            if (supSupOrg != null && (subOrgList = this.getDirectSubOrgs(supSupOrg.getOrgid(), con)) != null) {
                for (OrgModel subOrg : subOrgList) {
                    List listTemp = this.getDirectUsersByOrg(subOrg.getOrgid(), con);
                    list.addAll(listTemp);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getUpDownOrgUsers(String orgid, Connection con) {
        ArrayList list = new ArrayList();
        try {
            List subOrgList;
            String instuCde = this.getCurrentInstuCde();
            OrgModel supOrg = this.getParentOrg(orgid, con);
            if (supOrg == null) {
                return list;
            }
            String supOrgNo = supOrg.getOrgid();
            List supOrgList = this.getDirectUsersByOrg(supOrgNo, con);
            if (supOrgList != null && !supOrgList.isEmpty()) {
                list.addAll(supOrgList);
            }
            if ((subOrgList = this.getDirectSubOrgs(orgid, con)) != null) {
                for (OrgModel subOrg : subOrgList) {
                    List listTemp = this.getDirectUsersByOrg(subOrg.getOrgid(), con);
                    list.addAll(listTemp);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getSameOrgLine(String orgid, Connection con) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String instuCde = this.getCurrentInstuCde();
            PreparedStatement ps = con.prepareStatement("SELECT * FROM S_BCH START WITH BCH_CDE= ? CONNECT BY NOCYCLE PRIOR BCH_SUP_CDE=BCH_CDE");
            ps.setString(1, orgid);
            ResultSet rs = ps.executeQuery();
            List<Map<String, String>> datas = SqlUtil.rsToStrMap(rs);
            rs.close();
            ps.close();
            if (null != datas && !datas.isEmpty()) {
                for (Map<String, String> bch : datas) {
                    OrgModel supOrgModel = this.toOrgModel(bch);
                    list.add(supOrgModel.getOrgid());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getSameOrgLineUsers(String orgid, Connection con) {
        ArrayList list = new ArrayList();
        List supOrgs = this.getSameOrgLine(orgid, con);
        String instuCde = this.getCurrentInstuCde();
        for (int i = 0; i < supOrgs.size(); ++i) {
            String orgidTmp = (String)supOrgs.get(i);
            try {
                List listTemp = this.getDirectUsersByOrg(orgidTmp, con);
                if (!(listTemp != null & !listTemp.isEmpty())) continue;
                list.addAll(listTemp);
                continue;
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    public String getDeptOrgid(String orgid, Connection con) {
        return null;
    }

    public List getSubDeptByOrgid(String orgid, Connection con) {
        return new ArrayList();
    }

    public List getUpAndUpUpOrgUsers(String orgid, Connection con) {
        ArrayList list = new ArrayList();
        try {
            OrgModel supSupOrg;
            String instuCde = this.getCurrentInstuCde();
            OrgModel supOrg = this.getParentOrg(orgid, con);
            if (supOrg == null) {
                return list;
            }
            String supOrgNo = supOrg.getOrgid();
            List listTemp = this.getDirectUsersByOrg(supOrgNo, con);
            if (listTemp != null & !listTemp.isEmpty()) {
                list.addAll(listTemp);
            }
            if ((supSupOrg = this.getParentOrg(supOrgNo, con)) == null) {
                return list;
            }
            String supSupOrgNo = supSupOrg.getOrgid();
            List listTemp2 = this.getDirectUsersByOrg(supSupOrgNo, con);
            if (listTemp2 != null & !listTemp2.isEmpty()) {
                list.addAll(listTemp2);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    public List getSampeAndUpOrgUsers(String orgid, Connection con) {
        ArrayList list = new ArrayList();
        list.addAll(this.getSameOrgUsers(orgid, null, con));
        list.addAll(this.getSuperiorUsers(orgid, null, con));
        return list;
    }

    public List getSampeOrgOrDeptUsers(String orgid, Connection con) {
        return new ArrayList();
    }

    protected OrgModel toOrgModel(Map<String, String> org) {
        String supOrgId;
        OrgModel orgModel = new OrgModel();
        String orgId = org.get("BCH_CDE");
        if (orgId.equals(supOrgId = org.get("BCH_SUP_CDE"))) {
            supOrgId = null;
        }
        orgModel.setOrgid(orgId);
        orgModel.setOrgname(org.get("BCH_DESC"));
        orgModel.setSuporgid(supOrgId);
        int orgLevel = Integer.valueOf(org.get("BCH_LEVEL"));
        orgModel.setOrglevel(orgLevel);
        return orgModel;
    }

    protected UserModel toUserModel(Map<String, String> user) {
        UserModel userModel = new UserModel();
        userModel.setUserid(user.get("USR_CDE"));
        userModel.setUsername(user.get("USR_NAME"));
        userModel.setEmail(user.get("USR_EMAIL"));
        userModel.setMobile(user.get("USR_TEL"));
        userModel.setOrgid(user.get("USR_BCH"));
        return userModel;
    }

    private GroupModel toGroupModel(Map<String, String> duty) {
        GroupModel groupModel = new GroupModel();
        groupModel.setGroupid(duty.get("DUTY_CDE"));
        groupModel.setGroupname(duty.get("DUTY_DESC"));
        groupModel.setOrgid(this.getWfiCmisOrgId());
        return groupModel;
    }

    private RoleModel toRoleModel(Map<String, String> role) {
        RoleModel roleModel = new RoleModel();
        roleModel.setRoleid(role.get("ROLE_CDE"));
        roleModel.setRolename(role.get("ROLE_NAME"));
        roleModel.setOrgid(this.getWfiCmisOrgId());
        return roleModel;
    }

    protected String getCurrentInstuCde() {
        EChainRuntimeContext config = EChainRuntimeContext.instance();
        String instuCde = config.getInstuCde();
        if (instuCde == null) {
            // empty if block
        }
        return instuCde;
    }

    protected String getSignUser() {
        EChainRuntimeContext config = EChainRuntimeContext.instance();
        String signUser = config.getSignUserName();
        return signUser;
    }

    protected String getWfiCmisOrgId() {
        return "cmis";
    }
}

