/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.echain.client.message;

import cn.com.yusys.yusp.echain.client.message.InstanceMessageProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceMessageProcessorFactory {
    private final Logger log = LoggerFactory.getLogger(InstanceMessageProcessorFactory.class);
    private List<InstanceMessageProcessor> instanceMessageProcessors = new ArrayList<InstanceMessageProcessor>();

    public InstanceMessageProcessorFactory(List<InstanceMessageProcessor> instanceMessageProcessors) {
        if (instanceMessageProcessors != null) {
            this.instanceMessageProcessors.addAll(instanceMessageProcessors);
            Collections.sort(this.instanceMessageProcessors, new Comparator<InstanceMessageProcessor>(){

                @Override
                public int compare(InstanceMessageProcessor s1, InstanceMessageProcessor s2) {
                    if (s1.order() > s2.order()) {
                        return 1;
                    }
                    if (s1.order() < s2.order()) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        this.log.debug("instanceMessageProcessors:" + this.instanceMessageProcessors);
    }

    public List<InstanceMessageProcessor> getProcessors(String message) {
        ArrayList<InstanceMessageProcessor> list = new ArrayList<InstanceMessageProcessor>();
        for (InstanceMessageProcessor processor : this.instanceMessageProcessors) {
            if (!processor.should(message)) continue;
            list.add(processor);
        }
        return list;
    }
}

