/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KeyStoreUtil {
    private static final String CERT_TYPE = "X.509";

    public static PrivateKey getPrivateKeyFromJks(String path, String keyStorePwd, String keyPwd, String alias) throws Exception {
        try {
            KeyStore keyStore = KeyStore.getInstance("jks");
            FileInputStream jksInputStream = new FileInputStream(new File(path));
            keyStore.load(jksInputStream, keyStorePwd.toCharArray());
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, keyPwd.toCharArray());
            jksInputStream.close();
            return privateKey;
        }
        catch (Exception e) {
            throw new Exception("\u83b7\u53d6\u79c1\u94a5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5", e);
        }
    }

    public static X509Certificate getX509CertificateFromJks(String path, String keyStorePwd, String alias) throws Exception {
        try {
            KeyStore keyStore = KeyStore.getInstance("jks");
            FileInputStream jksInputStream = new FileInputStream(new File(path));
            keyStore.load(jksInputStream, keyStorePwd.toCharArray());
            Certificate certificate = keyStore.getCertificate(alias);
            jksInputStream.close();
            return (X509Certificate)certificate;
        }
        catch (Exception e) {
            throw new Exception("\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5", e);
        }
    }

    public static PublicKey getPublicKeyFromCer(String path) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(CERT_TYPE, (Provider)new BouncyCastleProvider());
        FileInputStream certInputStream = new FileInputStream(path);
        Certificate certificate = certificateFactory.generateCertificate(certInputStream);
        certInputStream.close();
        return certificate.getPublicKey();
    }
}

