/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.Base64Tools;
import java.io.ObjectInputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.util.Base64Utils;

public class BCRSAUtil {
    private static RSAPublicKey pubKey = null;
    private static RSAPrivateKey priKey = null;

    private static Key readKey(String keyName) throws Exception {
        ObjectInputStream keyIn = new ObjectInputStream(BCRSAUtil.class.getClassLoader().getResourceAsStream(keyName));
        Key key = (Key)keyIn.readObject();
        keyIn.close();
        return key;
    }

    public static String decrypt(String rawStr) throws Exception {
        byte[] rst = BCRSAUtil.decrypt(priKey, Base64.decodeBase64((String)rawStr));
        return new String(rst);
    }

    public static String encryptByRSA(String password) throws Exception {
        byte[] encodedData = BCRSAUtil.encryptByPublicKey(password.getBytes(), Base64Tools.encodeToString(pubKey.getEncoded(), false));
        String base64decryptString = Base64Tools.encodeToString(encodedData, false);
        return base64decryptString;
    }

    public static byte[] decrypt(Key key, byte[] raw) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/None/PKCS1Padding", "BC");
        cipher.init(2, key);
        return cipher.doFinal(raw);
    }

    public static byte[] encryptByRSA(byte[] pubKeyInByte, byte[] data) {
        try {
            KeyFactory mykeyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec pub_spec = new X509EncodedKeySpec(pubKeyInByte);
            PublicKey pubKey = mykeyFactory.generatePublic(pub_spec);
            Cipher cipher = Cipher.getInstance("RSA/None/PKCS1Padding", "BC");
            cipher.init(1, pubKey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] encryptByPublicKey(byte[] data, String publicKey) throws Exception {
        byte[] keyBytes = Base64Utils.decodeFromString((String)publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, publicK);
        return cipher.doFinal(data);
    }

    public static void main(String[] args) {
        String orgString = "admin";
        String encryptString = "";
        String decryptString = "";
        RSAPublicKey pubKey = null;
        RSAPrivateKey priKey = null;
        try {
            priKey = (RSAPrivateKey)BCRSAUtil.readKey("cert/pwd_private.key");
            pubKey = (RSAPublicKey)BCRSAUtil.readKey("cert/pwd_public.key");
            System.out.println("priKey:\n" + priKey + "\n");
            System.out.println("pubKey:\n" + pubKey + "\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\n=============================== Step-1:\u670d\u52a1\u7aef\u516c\u94a5\u52a0\u5bc6-\u670d\u52a1\u7aef\u79c1\u94a5\u89e3\u5bc6\n");
        try {
            byte[] data = orgString.getBytes();
            byte[] encodedData = BCRSAUtil.encryptByPublicKey(data, Base64Tools.encodeToString(pubKey.getEncoded(), false));
            encryptString = new String(encodedData);
            String base64decryptString = Base64Tools.encodeToString(encodedData, false);
            String base64decrypt = new String(Base64Tools.decode(base64decryptString));
            System.out.println("orginalString:" + orgString + "\n");
            System.out.println("encrypString:" + encryptString + "\n");
            System.out.println("base64decryptString:" + base64decryptString + "\n");
            System.out.println("base64decrypt:" + base64decrypt + "\n");
            decryptString = BCRSAUtil.decrypt(base64decryptString);
            System.out.println("decryptString:" + decryptString);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println("Step-5  \u89e3\u5bc6\u5931\u8d25!");
        }
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            priKey = (RSAPrivateKey)BCRSAUtil.readKey("cert/pwd_private.key");
            pubKey = (RSAPublicKey)BCRSAUtil.readKey("cert/pwd_public.key");
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }
}

