/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.util;

import cn.com.yusys.yusp.commons.util.ByteTools;
import cn.com.yusys.yusp.commons.util.FileTools;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesHandlerTools {
    private static final String AES = "AES";

    public static void encrypt(InputStream is, OutputStream out, byte[] password, String transformation) throws Exception {
        if (transformation.equals(AES)) {
            AesHandlerTools.encryptAes(is, out, password);
        } else {
            AesHandlerTools.encrypt(is, out, password);
        }
    }

    public static void decrypt(InputStream is, OutputStream out, byte[] password, String transformation) throws Exception {
        if (transformation.equals(AES)) {
            AesHandlerTools.decryptAes(is, out, password);
        } else {
            AesHandlerTools.decrypt(is, out, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encrypt(InputStream is, OutputStream out, byte[] password) throws Exception {
        if (password.length != 32) {
            throw new Exception("\u5bc6\u94a5\u957f\u5ea6\u4e0d\u4e3a32 !");
        }
        byte[] pass = new byte[16];
        byte[] ivi = new byte[16];
        System.arraycopy(password, 0, pass, 0, 16);
        System.arraycopy(password, 16, ivi, 0, 16);
        SecretKeySpec secretKeySpec = new SecretKeySpec(pass, AES);
        IvParameterSpec paramSpec = new IvParameterSpec(ivi);
        Cipher cipher = Cipher.getInstance("AES/CFB8/NoPadding");
        cipher.init(1, (Key)secretKeySpec, paramSpec);
        BufferedInputStream bi = new BufferedInputStream(is);
        CipherInputStream cis = new CipherInputStream(bi, cipher);
        BufferedOutputStream o = new BufferedOutputStream(out);
        try {
            FileTools.copyStream(cis, o);
        }
        finally {
            cis.close();
            bi.close();
            o.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrypt(InputStream is, OutputStream out, byte[] password) throws Exception {
        if (password.length != 32) {
            throw new Exception("\u5bc6\u94a5\u957f\u5ea6\u4e0d\u4e3a32 !");
        }
        byte[] pass = new byte[16];
        byte[] ivi = new byte[16];
        System.arraycopy(password, 0, pass, 0, 16);
        System.arraycopy(password, 16, ivi, 0, 16);
        SecretKeySpec secretKeySpec = new SecretKeySpec(pass, AES);
        IvParameterSpec paramSpec = new IvParameterSpec(ivi);
        Cipher cipher = Cipher.getInstance("AES/CFB8/NoPadding");
        cipher.init(2, (Key)secretKeySpec, paramSpec);
        BufferedInputStream bi = new BufferedInputStream(is);
        CipherOutputStream cos = new CipherOutputStream(out, cipher);
        BufferedOutputStream o = new BufferedOutputStream(cos);
        try {
            FileTools.copyStream(bi, o);
        }
        finally {
            o.close();
            cos.close();
            bi.close();
        }
    }

    public static byte[] getKey(Object password) throws Exception {
        byte[] key;
        byte[] pass = ByteTools.getBytes(password);
        if (pass.length > (key = new byte[32]).length) {
            System.arraycopy(pass, 0, key, 0, 32);
        } else {
            System.arraycopy(pass, 0, key, 0, pass.length);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encryptAes(InputStream is, OutputStream out, byte[] password) throws Exception {
        SecretKeySpec key = new SecretKeySpec(AesHandlerTools.generateKey(password), AES);
        Cipher cipher = Cipher.getInstance(AES);
        cipher.init(1, key);
        BufferedInputStream bi = new BufferedInputStream(is);
        CipherInputStream cis = new CipherInputStream(bi, cipher);
        BufferedOutputStream o = new BufferedOutputStream(out);
        try {
            FileTools.copyStream(cis, o);
        }
        finally {
            cis.close();
            bi.close();
            o.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decryptAes(InputStream is, OutputStream out, byte[] password) throws Exception {
        SecretKeySpec key = new SecretKeySpec(AesHandlerTools.generateKey(password), AES);
        Cipher cipher = Cipher.getInstance(AES);
        cipher.init(2, key);
        BufferedInputStream bi = new BufferedInputStream(is);
        CipherOutputStream cos = new CipherOutputStream(out, cipher);
        BufferedOutputStream o = new BufferedOutputStream(cos);
        try {
            FileTools.copyStream(bi, o);
        }
        finally {
            o.close();
            cos.close();
            bi.close();
        }
    }

    public static byte[] generateKey(byte[] password) {
        byte[] pwd = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
        int len = password.length;
        if (len > 16) {
            len = 16;
        }
        System.arraycopy(password, 0, pwd, 0, len);
        return pwd;
    }
}

