/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.core.thread;

import cn.com.yusys.yusp.commons.job.core.biz.model.HandleCallbackParam;
import cn.com.yusys.yusp.commons.job.core.biz.model.ReturnT;
import cn.com.yusys.yusp.commons.job.core.biz.model.TriggerParam;
import cn.com.yusys.yusp.commons.job.core.executor.XxlJobExecutor;
import cn.com.yusys.yusp.commons.job.core.handler.IJobHandler;
import cn.com.yusys.yusp.commons.job.core.log.JobFileAppender;
import cn.com.yusys.yusp.commons.job.core.log.JobLogger;
import cn.com.yusys.yusp.commons.job.core.thread.TriggerCallbackThread;
import cn.com.yusys.yusp.commons.job.core.util.ShardingUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobThread
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(JobThread.class);
    private String jobId;
    private IJobHandler handler;
    private LinkedBlockingQueue<TriggerParam> triggerQueue;
    private ConcurrentHashSet<String> triggerLogIdSet;
    private boolean toStop = false;
    private String stopReason;
    private boolean running = false;
    private int idleTimes = 0;

    public JobThread(String jobId, IJobHandler handler) {
        this.jobId = jobId;
        this.handler = handler;
        this.triggerQueue = new LinkedBlockingQueue();
        this.triggerLogIdSet = new ConcurrentHashSet();
    }

    public IJobHandler getHandler() {
        return this.handler;
    }

    public ReturnT<String> pushTriggerQueue(TriggerParam triggerParam) {
        if (this.triggerLogIdSet.contains((Object)triggerParam.getLogId())) {
            logger.info(">>>>>>>>>>> repeate trigger job, logId:{}", (Object)triggerParam.getLogId());
            return new ReturnT<String>("500", "repeate trigger job, logId:" + triggerParam.getLogId());
        }
        this.triggerLogIdSet.add((Object)triggerParam.getLogId());
        this.triggerQueue.add(triggerParam);
        return ReturnT.SUCCESS;
    }

    public void toStop(String stopReason) {
        this.toStop = true;
        this.stopReason = stopReason;
    }

    public boolean isRunningOrHasQueue() {
        return this.running || this.triggerQueue.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TriggerParam triggerParam;
        try {
            this.handler.init();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        while (!this.toStop) {
            ReturnT<String> stopResult;
            block18: {
                this.running = false;
                ++this.idleTimes;
                triggerParam = null;
                ReturnT<String> executeResult = null;
                try {
                    triggerParam = this.triggerQueue.poll(3L, TimeUnit.SECONDS);
                    if (triggerParam != null) {
                        this.running = true;
                        this.idleTimes = 0;
                        this.triggerLogIdSet.remove((Object)triggerParam.getLogId());
                        String logFileName = JobFileAppender.makeLogFileName(new Date(triggerParam.getLogDateTim()), triggerParam.getLogId());
                        JobFileAppender.contextHolder.set(logFileName);
                        ShardingUtil.setShardingVo(new ShardingUtil.ShardingVO(triggerParam.getBroadcastIndex(), triggerParam.getBroadcastTotal()));
                        JobLogger.log("<br>----------- job job execute start -----------<br>----------- Param:" + triggerParam.getExecutorParams(), new Object[0]);
                        executeResult = this.handler.execute(triggerParam.getExecutorParams());
                        if (executeResult == null) {
                            executeResult = IJobHandler.FAIL;
                        }
                        JobLogger.log("<br>----------- job job execute end(finish) -----------<br>----------- ReturnT:" + executeResult, new Object[0]);
                    } else if (this.idleTimes > 30) {
                        XxlJobExecutor.removeJobThread(this.jobId, "excutor idel times over limit.");
                    }
                    if (triggerParam == null) continue;
                    if (this.toStop) break block18;
                }
                catch (Throwable e) {
                    block19: {
                        try {
                            if (this.toStop) {
                                JobLogger.log("<br>----------- JobThread toStop, stopReason:" + this.stopReason, new Object[0]);
                            }
                            StringWriter stringWriter = new StringWriter();
                            e.printStackTrace(new PrintWriter(stringWriter));
                            String errorMsg = stringWriter.toString();
                            executeResult = new ReturnT<String>("500", errorMsg);
                            JobLogger.log("<br>----------- JobThread Exception:" + errorMsg + "<br>----------- job job execute end(error) -----------", new Object[0]);
                            if (triggerParam == null) continue;
                            if (this.toStop) break block19;
                        }
                        catch (Throwable throwable) {
                            if (triggerParam != null) {
                                if (!this.toStop) {
                                    TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), executeResult));
                                } else {
                                    ReturnT<String> stopResult2 = new ReturnT<String>("500", this.stopReason + " [\u4e1a\u52a1\u8fd0\u884c\u4e2d\uff0c\u88ab\u5f3a\u5236\u7ec8\u6b62]");
                                    TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), stopResult2));
                                }
                            }
                            throw throwable;
                        }
                        TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), executeResult));
                        continue;
                    }
                    stopResult = new ReturnT("500", this.stopReason + " [\u4e1a\u52a1\u8fd0\u884c\u4e2d\uff0c\u88ab\u5f3a\u5236\u7ec8\u6b62]");
                    TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), stopResult));
                    continue;
                }
                TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), executeResult));
                continue;
            }
            stopResult = new ReturnT<String>("500", this.stopReason + " [\u4e1a\u52a1\u8fd0\u884c\u4e2d\uff0c\u88ab\u5f3a\u5236\u7ec8\u6b62]");
            TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), stopResult));
        }
        while (this.triggerQueue != null && this.triggerQueue.size() > 0) {
            triggerParam = this.triggerQueue.poll();
            if (triggerParam == null) continue;
            ReturnT<String> stopResult = new ReturnT<String>("500", this.stopReason + " [\u4efb\u52a1\u5c1a\u672a\u6267\u884c\uff0c\u5728\u8c03\u5ea6\u961f\u5217\u4e2d\u88ab\u7ec8\u6b62]");
            TriggerCallbackThread.pushCallBack(new HandleCallbackParam(triggerParam.getLogId(), stopResult));
        }
        try {
            this.handler.destroy();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        logger.info(">>>>>>>>>>> job JobThread stoped, hashCode:{}", (Object)Thread.currentThread());
    }
}

