/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.trace.config;

import brave.Tracing;
import brave.propagation.B3Propagation;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.Propagation;
import cn.com.yusys.yusp.trace.aspect.TraceBaggageAspect;
import cn.com.yusys.yusp.trace.config.AppContext;
import cn.com.yusys.yusp.trace.config.Field;
import cn.com.yusys.yusp.trace.config.HeadProperty;
import cn.com.yusys.yusp.trace.service.CustomExpand;
import cn.com.yusys.yusp.trace.service.SeqGenerate;
import cn.com.yusys.yusp.trace.service.TracingService;
import cn.com.yusys.yusp.trace.service.impl.BaggageTraceServiceImpl;
import cn.com.yusys.yusp.trace.service.impl.CustomExpandImpl;
import cn.com.yusys.yusp.trace.service.impl.SeqGenerateImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"appContext"})
@EnableConfigurationProperties(value={TracingHeadAutoConfiguration.class})
@ConditionalOnClass(value={Tracing.class})
@AutoConfigureBefore(value={TraceAutoConfiguration.class})
public class TracingHeadAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(TracingHeadAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public Propagation.Factory sleuthPropagation(SleuthProperties sleuthProperties, HeadProperty headProperty) {
        ArrayList<String> sleuthKeys = sleuthProperties.getBaggageKeys();
        if (sleuthKeys == null) {
            sleuthKeys = new ArrayList<String>();
        }
        this.addCustomBaggageKeys(sleuthKeys, headProperty);
        sleuthProperties.setBaggageKeys(sleuthKeys);
        ExtraFieldPropagation.FactoryBuilder factoryBuilder = ExtraFieldPropagation.newFactoryBuilder((Propagation.Factory)B3Propagation.FACTORY);
        if (!sleuthProperties.getBaggageKeys().isEmpty()) {
            factoryBuilder = factoryBuilder.addPrefixedFields("baggage-", (Collection)sleuthProperties.getBaggageKeys()).addPrefixedFields("baggage_", (Collection)sleuthProperties.getBaggageKeys());
        }
        if (!sleuthProperties.getPropagationKeys().isEmpty()) {
            for (String key : sleuthProperties.getPropagationKeys()) {
                factoryBuilder = factoryBuilder.addField(key);
            }
        }
        return factoryBuilder.build();
    }

    private void addCustomBaggageKeys(List<String> keys, HeadProperty headProperty) {
        List<Field> keyField = headProperty.getField();
        for (Field cm : keyField) {
            String keyName = cm.getKey();
            keys.add(keyName);
            this.logger.info("\u6dfb\u52a0\u9ed8\u8ba4\u7684\u4e1a\u52a1baggage keys:{}", (Object)keyName);
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SeqGenerate seqGenerate() {
        return new SeqGenerateImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public TracingService tracingService() {
        return new BaggageTraceServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public CustomExpand customExpand() {
        Map processorBeanMap = null;
        CustomExpand obj = null;
        try {
            processorBeanMap = AppContext.getContext().getBeansOfType(CustomExpand.class);
        }
        catch (BeansException var5) {
            throw new RuntimeException("\u52a0\u8f7d\u811a\u672c\u5904\u7406\u5668Bean\u5931\u8d25\uff01");
        }
        if (processorBeanMap != null && processorBeanMap.size() > 0) {
            Map.Entry entry;
            Iterator var3 = processorBeanMap.entrySet().iterator();
            while (var3.hasNext() && (obj = (CustomExpand)(entry = var3.next()).getValue()) == null) {
            }
            return obj;
        }
        return new CustomExpandImpl();
    }

    @Bean
    public TraceBaggageAspect traceBaggageAspect(HeadProperty property, TracingService tracingService, SeqGenerate seqGenerate) {
        return new TraceBaggageAspect(property, seqGenerate, tracingService);
    }
}

