/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.trace.aspect;

import cn.com.yusys.yusp.trace.annotation.TraceBaggage;
import cn.com.yusys.yusp.trace.config.Field;
import cn.com.yusys.yusp.trace.config.HeadProperty;
import cn.com.yusys.yusp.trace.service.SeqGenerate;
import cn.com.yusys.yusp.trace.service.TracingService;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.MDC;

@Aspect
public class TraceBaggageAspect {
    private final HeadProperty head;
    private final SeqGenerate seqGenerate;
    private final TracingService tracingService;

    public TraceBaggageAspect(HeadProperty head, SeqGenerate seqGenerate, TracingService tracingService) {
        this.head = head;
        this.seqGenerate = seqGenerate;
        this.tracingService = tracingService;
    }

    @Before(value="@annotation(traceBaggage)")
    public void handleTraceBaggage(JoinPoint point, TraceBaggage traceBaggage) {
        MethodSignature methodSignature = (MethodSignature)MethodSignature.class.cast(point.getSignature());
        Method method = methodSignature.getMethod();
        String seqNo = this.seqGenerate.loadGlobalSeq(traceBaggage.seqNo(), method);
        String subSeqNo = this.seqGenerate.loadGlobalSeq(traceBaggage.subSeqNo(), method);
        this.updateGlobalSeq(seqNo);
        this.updateGlobalsubSeq(subSeqNo);
        List<Field> keyField = this.head.getField();
        JSONObject result = new JSONObject();
        for (Field cm : keyField) {
            String keyName = cm.getKey();
            if (keyName.equals("head")) continue;
            result.put(keyName, (Object)this.tracingService.get(keyName));
            MDC.put((String)keyName, (String)this.tracingService.get(keyName));
        }
        this.tracingService.set("head", JSONObject.toJSONString((Object)result));
    }

    private void updateGlobalSeq(String seqNo) {
        if (StringUtils.isNotEmpty((CharSequence)seqNo)) {
            this.tracingService.set("seqNo", seqNo);
        } else {
            String currentSeq = this.tracingService.get("seqNo");
            if (StringUtils.isEmpty((CharSequence)currentSeq)) {
                this.tracingService.set("seqNo", this.seqGenerate.generateSeq());
            }
        }
    }

    private void updateGlobalsubSeq(String subSeqNo) {
        if (StringUtils.isNotEmpty((CharSequence)subSeqNo)) {
            this.tracingService.set("subSeqNo", subSeqNo);
        } else {
            String currentSubSeq = this.tracingService.get("subSeqNo");
            if (StringUtils.isEmpty((CharSequence)currentSubSeq)) {
                this.tracingService.set("subSeqNo", this.seqGenerate.generateSubSeq());
            }
        }
    }
}

