/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.trace.service.impl;

import cn.com.yusys.yusp.commons.util.DateUtil;
import cn.com.yusys.yusp.sequence.client.SequenceTemplateService;
import cn.com.yusys.yusp.trace.service.SeqGenerate;
import cn.com.yusys.yusp.util.EnvironmentUtils;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;

public class SeqGenerateImpl
implements SeqGenerate {
    private static final Logger logger = LoggerFactory.getLogger(SeqGenerateImpl.class);
    @Autowired
    private SequenceTemplateService sequenceTemplateService;

    @Override
    public String generateSeq() {
        Date date = new Date();
        String tranDate = DateUtil.formatDate((Date)date, (String)"yyyyMMdd");
        String systemName = EnvironmentUtils.getApplicationId();
        String curConsumerId = EnvironmentUtils.getApplicationName();
        curConsumerId = curConsumerId.split("-")[0];
        String seqNo = this.sequenceNo();
        logger.info("\u5168\u5c40\u987a\u5e8f\u53f7{}", (Object)seqNo);
        return this.buildSeqNo(systemName, curConsumerId, tranDate, seqNo);
    }

    public String buildSeqNo(String systemName, String curConsumerId, String tranDate, String seqNo) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(curConsumerId);
        strBuffer.append(tranDate);
        strBuffer.append(seqNo);
        return strBuffer.toString();
    }

    @Override
    public String generateSubSeq() {
        Date date = new Date();
        String tranDate = DateUtil.formatDate((Date)date, (String)"yyyyMMdd");
        String curConsumerId = EnvironmentUtils.getApplicationName();
        curConsumerId = curConsumerId.split("-")[0];
        String systemName = EnvironmentUtils.getApplicationId();
        String subSeqNo = this.subSequenceNo();
        logger.info("\u5b50\u987a\u5e8f\u53f7{}", (Object)subSeqNo);
        return SeqGenerateImpl.buildSubSeqNo(systemName, curConsumerId, tranDate, subSeqNo);
    }

    public static String buildSubSeqNo(String systemName, String curConsumerId, String tranDate, String subSeqNo) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(curConsumerId);
        strBuffer.append("S");
        strBuffer.append(tranDate);
        strBuffer.append(subSeqNo);
        return strBuffer.toString();
    }

    public String sequenceNo() {
        String globalSeq = "";
        try {
            globalSeq = this.sequenceTemplateService.getSequenceTemplate("GLOBAL_SEQ_ID", new HashMap());
        }
        catch (Exception var3) {
            logger.warn("\u83b7\u53d6\u5168\u5c40\u6d41\u6c34\u7684\u987a\u5e8f\u53f7\u51fa\u9519", (Throwable)var3);
        }
        return globalSeq;
    }

    public String subSequenceNo() {
        String subSeq = "";
        try {
            subSeq = this.sequenceTemplateService.getSequenceTemplate("SUB_SEQ_ID", new HashMap());
        }
        catch (Exception var3) {
            logger.warn("\u83b7\u53d6\u5b50\u5e8f\u53f7\u6d41\u6c34\u7684\u987a\u5e8f\u53f7\u51fa\u9519", (Throwable)var3);
        }
        return subSeq;
    }

    @Override
    public String loadGlobalSeq(@Nullable String seq, Method method) {
        return seq;
    }
}

