/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.trace.filter;

import cn.com.yusys.yusp.trace.config.Field;
import cn.com.yusys.yusp.trace.config.HeadProperty;
import cn.com.yusys.yusp.trace.service.CustomExpand;
import cn.com.yusys.yusp.trace.service.SeqGenerate;
import cn.com.yusys.yusp.trace.service.TracingService;
import cn.com.yusys.yusp.util.EnvironmentUtils;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TracingBusiFilter
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(TracingBusiFilter.class);
    private final TracingService tracingService;
    private final HeadProperty headProperty;
    private final CustomExpand customExpand;
    private final SeqGenerate seqGenerate;

    public TracingBusiFilter(SeqGenerate seqGenerate, TracingService tracingService, HeadProperty headProperty, CustomExpand customExpand) {
        this.tracingService = tracingService;
        this.seqGenerate = seqGenerate;
        this.headProperty = headProperty;
        this.customExpand = customExpand;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            if (StringUtils.isBlank((CharSequence)request.getHeader("head"))) {
                this.logger.warn("\u83b7\u53d6\u8bf7\u6c42\u5934\u4e3a\u7a7a");
            }
            String headValue = !StringUtils.isBlank((CharSequence)request.getHeader("head")) ? request.getHeader("head") : this.tracingService.get("head");
            this.handleTracingBusi(this.headProperty.getField(), headValue, request, response);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            this.logger.error("\u672c\u5730\u8c03\u7528\u5f02\u5e38{}", (Throwable)e);
            this.setErrHead(response, e);
        }
    }

    private boolean handleTracingBusi(List<Field> keyreferers, String headValue, HttpServletRequest request, HttpServletResponse response) {
        ObjectMapper mapper = new ObjectMapper();
        Map map = null;
        JSONObject result = new JSONObject();
        for (int i = 0; i < keyreferers.size(); ++i) {
            String keyName = keyreferers.get(i).getKey();
            if (StringUtils.isBlank((CharSequence)headValue)) {
                this.logger.warn("\u83b7\u53d6head\u4e3a\u7a7a");
                return false;
            }
            if (keyName.equals("head")) {
                try {
                    map = (Map)mapper.readValue(headValue, Map.class);
                }
                catch (Exception var12) {
                    this.logger.error("\u8bfb\u53d6header\u89e3\u6790\u5f02\u5e38", (Object)var12.getMessage());
                }
            } else {
                String keyValue;
                String string = keyValue = (String)map.get(keyName) == null ? "" : (String)map.get(keyName);
                if ("seqNo".equals(keyName) && StringUtils.isEmpty((CharSequence)keyValue)) {
                    keyValue = this.seqGenerate.generateSeq();
                }
                if ("subSeqNo".equals(keyName)) {
                    keyValue = this.seqGenerate.generateSubSeq();
                }
                if (StringUtils.isEmpty((CharSequence)((String)map.get(keyName))) && !"".equals(this.customExpand.addValue(keyName)) && this.customExpand.addValue(keyName) != null) {
                    this.logger.info("addValue\u540d\u5b57{},\u503c{}", (Object)keyName, (Object)this.customExpand.addValue(keyName));
                    keyValue = this.customExpand.addValue(keyName);
                }
                this.tracingService.set(keyName, keyValue);
                this.envUpdate();
                result.put(keyName, (Object)this.tracingService.get(keyName));
                MDC.put((String)keyName, (String)this.tracingService.get(keyName));
            }
            this.tracingService.set("head", JSONObject.toJSONString((Object)result));
            this.logger.info("\u53c2\u6570\u540d{};\u53c2\u6570\u503c{}", (Object)keyName, (Object)this.tracingService.get(keyName));
        }
        try {
            this.setHeader(response, this.tracingService.get("head"));
        }
        catch (JsonProcessingException var11) {
            this.logger.error("\u8bbe\u7f6e\u54cd\u5e94header\u5f02\u5e38", (Object)var11.getMessage());
        }
        this.logger.info("head\u503c" + response.getHeader("head"));
        return true;
    }

    private void envUpdate() {
        String serviceCode = EnvironmentUtils.getApplicationName();
        if (StringUtils.isNotEmpty((CharSequence)serviceCode)) {
            this.tracingService.set("curConsumer", serviceCode);
        }
    }

    private void setHeader(HttpServletResponse response, String map) throws JsonProcessingException {
        JSONObject sysHead = JSONObject.parseObject((String)map);
        JSONObject ret = new JSONObject();
        if (sysHead != null) {
            ret.put("retCode", (Object)response.getStatus());
            ret.put("retMsg", (Object)"SUCCESS");
            sysHead.put("retArray", (Object)ret);
            sysHead.put("retStatus", (Object)"S");
            response.addHeader("head", sysHead.toJSONString());
        }
    }

    private void setErrHead(HttpServletResponse response, Exception ex) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ex message:[{}]", (Object)ex.getMessage());
        }
        JSONObject sysHead = new JSONObject();
        JSONObject ret = new JSONObject();
        ret.put("retCode", (Object)response.getStatus());
        try {
            String message = ex.getMessage();
            if (message != null) {
                if (URLDecoder.decode(message, "UTF-8") == message) {
                    message = URLEncoder.encode(message, "UTF-8");
                }
            } else {
                message = "";
            }
            ret.put("retMsg", (Object)message);
        }
        catch (UnsupportedEncodingException var6) {
            var6.printStackTrace();
            ret.put("retMsg", (Object)ex.getMessage());
        }
        sysHead.put("retArray", (Object)ret);
        sysHead.put("retStatus", (Object)"F");
        response.setHeader("head", sysHead.toJSONString());
    }

    public void destroy() {
    }
}

