/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.service.AuthService;
import cn.com.yusys.yusp.commons.service.impl.AuthRuleServiceCacheImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfigureAfter(value={CacheAutoConfiguration.class})
public class SecurityCacheAutoConfiguration {
    private final Logger logger = LoggerFactory.getLogger(SecurityCacheAutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(name={"application.cache.serviceauth.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={AuthService.class})
    public AuthService serviceAuthCacheService() {
        this.logger.info("Service authentication query, load AuthRuleServiceCacheImpl, based on cache");
        return new AuthRuleServiceCacheImpl();
    }
}

