/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.servlet.InstrumentedFilter;
import com.codahale.metrics.servlets.MetricsServlet;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WebConfigurer
implements ServletContextInitializer {
    private final Logger log = LoggerFactory.getLogger(WebConfigurer.class);
    private MetricRegistry metricRegistry;

    public void onStartup(ServletContext servletContext) throws ServletException {
        EnumSet<DispatcherType> disps = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC);
        this.initMetrics(servletContext, disps);
        this.log.info("Web application fully configured");
    }

    private void initMetrics(ServletContext servletContext, EnumSet<DispatcherType> disps) {
        this.log.debug("Initializing Metrics registries");
        servletContext.setAttribute(InstrumentedFilter.REGISTRY_ATTRIBUTE, (Object)this.metricRegistry);
        servletContext.setAttribute(MetricsServlet.METRICS_REGISTRY, (Object)this.metricRegistry);
        this.log.debug("Registering Metrics Filter");
        FilterRegistration.Dynamic metricsFilter = servletContext.addFilter("webappMetricsFilter", (Filter)new InstrumentedFilter());
        metricsFilter.addMappingForUrlPatterns(disps, true, new String[]{"/*"});
        metricsFilter.setAsyncSupported(true);
        this.log.debug("Registering Metrics Servlet");
        ServletRegistration.Dynamic metricsAdminServlet = servletContext.addServlet("metricsServlet", (Servlet)new MetricsServlet());
        metricsAdminServlet.addMapping(new String[]{"/actuator/metrics/*"});
        metricsAdminServlet.setAsyncSupported(true);
        metricsAdminServlet.setLoadOnStartup(2);
    }

    @Autowired(required=false)
    public void setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }
}

