/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.config;

import cn.com.yusys.yusp.commons.config.MetricsAddGaugeSet;
import com.codahale.metrics.JvmAttributeGaugeSet;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.ryantenney.metrics.spring.config.annotation.EnableMetrics;
import com.ryantenney.metrics.spring.config.annotation.MetricsConfigurerAdapter;
import java.lang.management.ManagementFactory;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableMetrics(proxyTargetClass=true)
public class MetricsConfiguration
extends MetricsConfigurerAdapter {
    private static final String PROP_METRIC_REG_JVM_MEMORY = "jvm.memory";
    private static final String PROP_METRIC_REG_JVM_GARBAGE = "jvm.garbage";
    private static final String PROP_METRIC_REG_JVM_THREADS = "jvm.threads";
    private static final String PROP_METRIC_REG_JVM_FILES = "jvm.files";
    private static final String PROP_METRIC_REG_JVM_BUFFERS = "jvm.buffers";
    private static final String PROP_METRIC_REG_JVM_ATTRIBUTE_SET = "jvm.attributes";
    private static final String PROP_METRIC_REG_JVM_CLASSES = "jvm.classes";
    private static final String PROP_METRIC_REG_JVM_ADD = "";
    private final Logger log = LoggerFactory.getLogger(MetricsConfiguration.class);
    private MetricRegistry metricRegistry = new MetricRegistry();

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    @PostConstruct
    public void init() {
        this.log.debug("Registering JVM gauges");
        this.metricRegistry.register(PROP_METRIC_REG_JVM_MEMORY, (Metric)new MemoryUsageGaugeSet());
        this.metricRegistry.register(PROP_METRIC_REG_JVM_GARBAGE, (Metric)new GarbageCollectorMetricSet());
        this.metricRegistry.register(PROP_METRIC_REG_JVM_THREADS, (Metric)new ThreadStatesGaugeSet());
        this.metricRegistry.register(PROP_METRIC_REG_JVM_FILES, (Metric)new FileDescriptorRatioGauge());
        this.metricRegistry.register(PROP_METRIC_REG_JVM_BUFFERS, (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        this.metricRegistry.register(PROP_METRIC_REG_JVM_ATTRIBUTE_SET, (Metric)new JvmAttributeGaugeSet());
        this.metricRegistry.register(PROP_METRIC_REG_JVM_CLASSES, (Metric)new ClassLoadingGaugeSet());
        this.metricRegistry.register(PROP_METRIC_REG_JVM_ADD, (Metric)new MetricsAddGaugeSet());
    }
}

