/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.aop.dataauth;

import cn.com.yusys.yusp.commons.aop.dataauth.excepton.DataAuthException;
import cn.com.yusys.yusp.commons.aop.dataauth.handler.DataAuthParamHander;
import cn.com.yusys.yusp.commons.mapper.interceptor.DataAuthHandler;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Deprecated
@Aspect
public class DataAuthAspect {
    private final Logger log = LoggerFactory.getLogger(DataAuthAspect.class);
    public static final String DATAAUTH_SQLNAME = "dataAuthSqlName";
    public static final String DATAAUTH_TEMPLATE = "dataAuthTemplate";
    public static final String DATAAUTH_PARAMS = "dataAuthParams";
    public static final String DATAAUTH_HEADER_ENC = "UTF-8";
    public static final String POINTCUT_EXPRESS = "within(cn.com.yusys..*) && (@target(org.springframework.web.bind.annotation.RestController) || @target(org.springframework.stereotype.Controller))";
    private DataAuthParamHander dataAuthParamHander;

    public DataAuthAspect(DataAuthParamHander dataAuthParamHander) {
        this.dataAuthParamHander = dataAuthParamHander;
    }

    @Pointcut(value="within(cn.com.yusys..*) && (@target(org.springframework.web.bind.annotation.RestController) || @target(org.springframework.stereotype.Controller))")
    public void pointcut() {
    }

    @Before(value="pointcut()")
    public void before(JoinPoint point) {
        try {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (requestAttributes != null) {
                HttpServletRequest request = requestAttributes.getRequest();
                String dataAuthTemplate = request.getHeader(DATAAUTH_TEMPLATE);
                String dataAuthParams = request.getHeader(DATAAUTH_PARAMS);
                if (dataAuthTemplate != null && !"".equals(dataAuthTemplate.trim()) && dataAuthParams != null && !"".equals(dataAuthParams.trim())) {
                    Map<String, Object> dataAuthParamsMap = this.getDataAuthParams(dataAuthParams);
                    DataAuthHandler.dataAuthTemplate.set(dataAuthTemplate);
                    DataAuthHandler.dataAuthParams.set(dataAuthParamsMap);
                    this.log.debug("Data permission template: " + dataAuthTemplate + " parameter: " + dataAuthParams);
                } else {
                    this.log.debug("Data permission template or parameter does not exist. Data permission processing is not performed");
                }
            } else {
                this.log.debug("Unable to get HTTP request, no data permission processing");
            }
        }
        catch (Exception e) {
            throw new DataAuthException(e);
        }
    }

    @After(value="pointcut()")
    public void after(JoinPoint point) {
    }

    protected Map<String, Object> getDataAuthParams(String dataAuthParams) throws UnsupportedEncodingException {
        String decodeDataAuthParams = URLDecoder.decode(dataAuthParams, DATAAUTH_HEADER_ENC);
        return this.dataAuthParamHander.getParams(decodeDataAuthParams);
    }
}

