/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper.interceptor;

import cn.com.yusys.yusp.commons.mapper.interceptor.DataAuthHandler;
import cn.com.yusys.yusp.commons.mapper.provider.OGNLUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataAuthHandler
implements DataAuthHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean handDataAuth(String sqlId, Object queryParameter) {
        if (queryParameter == null || OGNLUtil.isBasic(queryParameter)) {
            this.log.debug("The parameter is null or the basic data type cannot set the recordset permission");
            return false;
        }
        this.clearDataAuthField(queryParameter);
        String template = this.getTemplate(sqlId);
        if (template == null || "".equals(template.trim())) {
            return false;
        }
        Map<String, Object> params = this.getParams(sqlId);
        String dataAuthValue = this.replaceTemplateParams(sqlId, template, params);
        return this.setDataAuthParams(queryParameter, dataAuthValue);
    }

    public abstract String getTemplate(String var1);

    public abstract Map<String, Object> getParams(String var1);

    public abstract String replaceTemplateParams(String var1, String var2, Map<String, Object> var3);

    public abstract boolean setDataAuthParams(Object var1, String var2);

    public abstract boolean clearDataAuthField(Object var1);
}

