/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper.interceptor;

import cn.com.yusys.yusp.commons.mapper.annotation.Generated;
import cn.com.yusys.yusp.commons.mapper.interceptor.BeanUtil;
import cn.com.yusys.yusp.commons.mapper.interceptor.ValueGenerator;
import java.lang.reflect.Field;
import java.util.UUID;
import org.apache.ibatis.mapping.SqlCommandType;

public class UUIDInsertGenerator
implements ValueGenerator {
    @Override
    public void generate(Object domain, Field field) {
        String value = UUID.randomUUID().toString().replace("-", "");
        BeanUtil.setFieldValue(domain, field, value);
    }

    @Override
    public boolean check(SqlCommandType commandType, Object domain, Field field) {
        if (!commandType.equals((Object)SqlCommandType.INSERT)) {
            return false;
        }
        Generated annotation = BeanUtil.findAnnotation(field, Generated.class);
        if (annotation == null) {
            return false;
        }
        String annotationValue = annotation.value();
        if (!"UUID".equals(annotationValue)) {
            return false;
        }
        Object fieldValue = BeanUtil.getFieldValue(field, domain);
        return fieldValue == null;
    }
}

