/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.mapper.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;

public class BeanUtil {
    public static <T> List<Field> findAllFields(Class<T> clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        List<Field> declaredFieldList = Arrays.asList(declaredFields);
        ArrayList<Field> allFieldList = new ArrayList<Field>();
        allFieldList.addAll(declaredFieldList);
        return allFieldList;
    }

    public static <T> Field findFieldWithParent(Class<T> clazz, String fieldName) {
        Field field = null;
        Class<T> cClazz = clazz;
        while (field == null && cClazz != null) {
            try {
                field = cClazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e1) {
                field = null;
            }
            if (field != null) continue;
            Class<T> superClass = cClazz.getSuperclass();
            if (superClass != null && !superClass.equals(Object.class) && (superClass.isAnnotationPresent(Entity.class) || !Map.class.isAssignableFrom(superClass) && !Collection.class.isAssignableFrom(superClass))) {
                cClazz = superClass;
                continue;
            }
            cClazz = null;
        }
        return field;
    }

    public static <A extends Annotation> A findAnnotation(Field field, Class<A> annotationClass) {
        return field.getAnnotation(annotationClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> void setFieldValue(T target, Field field, Object value) {
        try {
            String fieldName = field.getName();
            Method method = null;
            try {
                method = target.getClass().getMethod("set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), field.getType());
            }
            catch (NoSuchMethodException e) {
                method = null;
            }
            catch (SecurityException e) {
                method = null;
            }
            Object setValue = BeanUtil.convertFieldValue(field, value);
            if (method == null) {
                if (!Modifier.isPublic(field.getModifiers())) throw new RuntimeException("\u5c5e\u6027[" + field + "]\u4e3a\u975e\u5171\u6709\u6216\u8005\u4e0d\u5b58\u5728\u5171\u6709setter\u65b9\u6cd5");
                field.set(target, setValue);
                return;
            } else {
                if (setValue == null && field.getType().isPrimitive()) return;
                method.invoke(target, setValue);
            }
            return;
        }
        catch (Exception e) {
            throw new RuntimeException("\u5c5e\u6027\u8d4b\u503c\u51fa\u9519", e);
        }
    }

    public static Object getFieldValue(Field field, Object object) {
        try {
            String fieldName = field.getName();
            Method method = null;
            try {
                method = object.getClass().getMethod("get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                method = null;
            }
            catch (SecurityException e) {
                method = null;
            }
            if (method == null) {
                if (Modifier.isPublic(field.getModifiers())) {
                    return field.get(object);
                }
                throw new RuntimeException("\u5c5e\u6027[" + field + "]\u4e3a\u975e\u5171\u6709\u6216\u8005\u4e0d\u5b58\u5728\u5171\u6709getter\u65b9\u6cd5");
            }
            Object value = method.invoke(object, new Object[0]);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException("\u5c5e\u6027\u83b7\u53d6\u503c\u51fa\u9519", e);
        }
    }

    public static Object convertFieldValue(Field field, Object value) {
        Class<?> targetClass = field.getType();
        if (value == null) {
            return value;
        }
        if (targetClass.isInstance(value)) {
            return value;
        }
        if (String.class == targetClass) {
            return value.toString();
        }
        if ("".equals(value.toString().trim())) {
            return null;
        }
        if (Boolean.class == targetClass || targetClass.getName().equalsIgnoreCase("boolean")) {
            return Boolean.valueOf(value.toString());
        }
        if (Character.class == targetClass || targetClass.getName().equalsIgnoreCase("char")) {
            return Character.valueOf(value.toString().charAt(0));
        }
        if (Byte.class == targetClass || targetClass.getName().equalsIgnoreCase("Byte")) {
            return Byte.valueOf(value.toString());
        }
        if (Short.class == targetClass || targetClass.getName().equalsIgnoreCase("Short")) {
            return Short.valueOf(value.toString());
        }
        if (Integer.class == targetClass || targetClass.getName().equalsIgnoreCase("Integer")) {
            return Integer.valueOf(value.toString());
        }
        if (Long.class == targetClass || targetClass.getName().equalsIgnoreCase("Long")) {
            return Long.valueOf(value.toString());
        }
        if (BigInteger.class == targetClass) {
            return BigInteger.valueOf(Long.valueOf(value.toString()));
        }
        if (Float.class == targetClass || targetClass.getName().equalsIgnoreCase("Float")) {
            return Float.valueOf(value.toString());
        }
        if (Double.class == targetClass || targetClass.getName().equalsIgnoreCase("Double")) {
            return Double.valueOf(value.toString());
        }
        if (BigDecimal.class == targetClass) {
            return new BigDecimal(value.toString());
        }
        throw new RuntimeException(value.getClass() + "\u8f6c\u6362\u4e3a" + targetClass + "\u4e0d\u88ab\u652f\u6301");
    }

    public static String convertFieldValueToStr(Field field, Object value) {
        Class<?> targetClass = field.getType();
        if (value == null) {
            return "";
        }
        if (String.class == targetClass) {
            return value.toString();
        }
        if ("".equals(value.toString().trim())) {
            return "";
        }
        if (Boolean.class == targetClass || targetClass.getName().equalsIgnoreCase("boolean")) {
            return String.valueOf(value);
        }
        if (Character.class == targetClass || targetClass.getName().equalsIgnoreCase("char")) {
            return String.valueOf(value);
        }
        if (Byte.class == targetClass || targetClass.getName().equalsIgnoreCase("Byte")) {
            byte[] valueT = (byte[])value;
            return new String(valueT);
        }
        if (Short.class == targetClass || targetClass.getName().equalsIgnoreCase("Short")) {
            return String.valueOf(value);
        }
        if (Integer.class == targetClass || targetClass.getName().equalsIgnoreCase("Integer")) {
            return String.valueOf(value);
        }
        if (Long.class == targetClass || targetClass.getName().equalsIgnoreCase("Long")) {
            return String.valueOf(value);
        }
        if (BigInteger.class == targetClass) {
            return ((BigInteger)value).toString(10);
        }
        if (Float.class == targetClass || targetClass.getName().equalsIgnoreCase("Float")) {
            return String.valueOf(value);
        }
        if (Double.class == targetClass || targetClass.getName().equalsIgnoreCase("Double")) {
            return String.valueOf(value);
        }
        if (BigDecimal.class == targetClass) {
            return value.toString();
        }
        throw new RuntimeException(value.getClass() + "\u8f6c\u6362\u4e3a" + targetClass + "\u4e0d\u88ab\u652f\u6301");
    }
}

