/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.jvm.collect;

import cn.com.yusys.yusp.commons.log.jvm.collect.LocalLogMetricsEndpoint;
import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.info.InfoEndpoint;
import org.springframework.boot.actuate.metrics.MetricsEndpoint;
import org.springframework.util.CollectionUtils;

public class LocalLogMetricsEndpointImpl
implements LocalLogMetricsEndpoint {
    private final Logger log = LoggerFactory.getLogger(LocalLogMetricsEndpointImpl.class);
    @Autowired
    private MetricsEndpoint metricsEndpoint;
    @Autowired
    private HealthEndpoint healthEndpoint;
    @Autowired
    private InfoEndpoint infoEndpoint;

    @Override
    public Double getMetricBySystemCpuUsage() {
        Double cpuUseRate = 0.0;
        try {
            List sampleList;
            MetricsEndpoint.MetricResponse metricResponse = this.metricsEndpoint.metric("system.cpu.usage", null);
            if (metricResponse != null && !CollectionUtils.isEmpty((Collection)(sampleList = metricResponse.getMeasurements()))) {
                MetricsEndpoint.Sample sample = (MetricsEndpoint.Sample)sampleList.get(0);
                cpuUseRate = sample.getValue();
            }
        }
        catch (Exception e) {
            this.log.error("getMetricBySystemCpuUsage method error", (Throwable)e);
        }
        return cpuUseRate;
    }

    @Override
    public Double getMetricByProcessCpuUsage() {
        Double cpuUseRate = 0.0;
        try {
            List sampleList;
            MetricsEndpoint.MetricResponse metricResponse = this.metricsEndpoint.metric("process.cpu.usage", null);
            if (metricResponse != null && !CollectionUtils.isEmpty((Collection)(sampleList = metricResponse.getMeasurements()))) {
                MetricsEndpoint.Sample sample = (MetricsEndpoint.Sample)sampleList.get(0);
                cpuUseRate = sample.getValue();
            }
        }
        catch (Exception e) {
            this.log.error("getMetricByProcessCpuUsage method error", (Throwable)e);
        }
        return cpuUseRate;
    }

    @Override
    public MetricsEndpoint.MetricResponse getMetricByJvmGc() {
        MetricsEndpoint.MetricResponse metricResponse = null;
        try {
            metricResponse = this.metricsEndpoint.metric("jvm.gc.pause", null);
        }
        catch (Exception e) {
            this.log.error("getMetricByJvmGc method error", (Throwable)e);
        }
        return metricResponse;
    }

    @Override
    public Health getAppHealthStatus() {
        Health health = null;
        try {
            health = this.healthEndpoint.health();
        }
        catch (Exception e) {
            this.log.error("getAppHealthStatus method error", (Throwable)e);
        }
        return health;
    }

    @Override
    public Map<String, Object> getAppInfo() {
        HashMap<String, Object> infoMap = new HashMap();
        try {
            infoMap = this.infoEndpoint.info();
            this.log.debug("info is :" + JSON.toJSONString(infoMap));
        }
        catch (Exception e) {
            this.log.error("getAppInfo method error", (Throwable)e);
        }
        return infoMap;
    }
}

