/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.jvm.collect;

import cn.com.yusys.yusp.commons.log.common.util.StringUtil;
import cn.com.yusys.yusp.commons.log.jvm.JvmLogger;
import cn.com.yusys.yusp.commons.log.jvm.collect.LocalLogMetricsEndpoint;
import cn.com.yusys.yusp.commons.log.jvm.domain.ClassLoadingBean;
import cn.com.yusys.yusp.commons.log.jvm.domain.CompilationBean;
import cn.com.yusys.yusp.commons.log.jvm.domain.HeapMemoryUsage;
import cn.com.yusys.yusp.commons.log.jvm.domain.JvmMonitorEntity;
import cn.com.yusys.yusp.commons.log.jvm.domain.MemoryBean;
import cn.com.yusys.yusp.commons.log.jvm.domain.NonHeapMemoryUsage;
import cn.com.yusys.yusp.commons.log.jvm.domain.OperatingSystemBean;
import cn.com.yusys.yusp.commons.log.jvm.domain.RuntimeBean;
import cn.com.yusys.yusp.commons.log.jvm.domain.ThreadBean;
import com.alibaba.fastjson.JSON;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.metrics.MetricsEndpoint;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.util.StringUtils;

public class JvmLoggerTask
implements SchedulingConfigurer,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(JvmLoggerTask.class);
    private static JvmMonitorEntity jvmMonitorEntity = JvmMonitorEntity.getJvmMonitorEntityInstance();
    private static ClassLoadingBean classLoadingBean = new ClassLoadingBean();
    private static CompilationBean compilationBean = new CompilationBean();
    private static OperatingSystemBean operatingSystemBean = new OperatingSystemBean();
    private static RuntimeBean runtimeBean = new RuntimeBean();
    private static ThreadBean threadBean = new ThreadBean();
    private static MemoryBean memoryBean = new MemoryBean();
    private static HeapMemoryUsage heapMemoryUsageBean = new HeapMemoryUsage();
    private static NonHeapMemoryUsage nonHeapMemoryUsageBean = new NonHeapMemoryUsage();
    private static ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
    private static CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
    private static MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private static OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private static ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
    private static MemoryUsage nonHeapMemoryUsage = memoryMXBean.getNonHeapMemoryUsage();
    private static RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private boolean shutdown = false;
    @Value(value="${application.log.jvm.collectFreq:0/2 * * * * ?}")
    private String cron;
    @Autowired
    private LocalLogMetricsEndpoint localLogMetricsEndpoint;

    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        scheduledTaskRegistrar.addTriggerTask(() -> {
            try {
                if (this.shutdown) {
                    log.info("shutdown jvm log task");
                    scheduledTaskRegistrar.destroy();
                } else {
                    this.writeLog();
                }
            }
            catch (Exception e) {
                log.error("writeLog", (Throwable)e);
            }
        }, triggerContext -> {
            if (StringUtils.isEmpty((Object)this.cron)) {
                this.cron = this.getCron();
            }
            CronTrigger trigger = new CronTrigger(this.cron);
            return trigger.nextExecutionTime(triggerContext);
        });
    }

    public JvmMonitorEntity printJvmAllInfo() {
        try {
            jvmMonitorEntity = this.printJvmInfo();
            if (jvmMonitorEntity != null) {
                Double processCpuUsage = this.localLogMetricsEndpoint.getMetricByProcessCpuUsage();
                jvmMonitorEntity.setProcessCpuUsage(processCpuUsage);
                Double systemCpuUsage = this.localLogMetricsEndpoint.getMetricBySystemCpuUsage();
                jvmMonitorEntity.setSystemCpuUsage(systemCpuUsage);
                MetricsEndpoint.MetricResponse gcMetricResponse = this.localLogMetricsEndpoint.getMetricByJvmGc();
                jvmMonitorEntity.setGcMetricResponse(gcMetricResponse);
                Health health = this.localLogMetricsEndpoint.getAppHealthStatus();
                jvmMonitorEntity.setHealth(JSON.toJSONString((Object)health));
                Map<String, Object> infoMap = this.localLogMetricsEndpoint.getAppInfo();
                jvmMonitorEntity.setInfoMap(infoMap);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return jvmMonitorEntity;
    }

    public void destroy() throws Exception {
        this.shutdown = true;
    }

    public JvmMonitorEntity printJvmInfo() {
        try {
            classLoadingBean.setLoadedClassCount(classLoadingMXBean.getLoadedClassCount());
            classLoadingBean.setTotalLoadedClassCount(classLoadingMXBean.getTotalLoadedClassCount());
            classLoadingBean.setUnloadedClassCount(classLoadingMXBean.getUnloadedClassCount());
            jvmMonitorEntity.setClassLoadingBean(classLoadingBean);
            compilationBean.setName(compilationMXBean.getName());
            if (compilationMXBean.isCompilationTimeMonitoringSupported()) {
                compilationBean.setTotalCompilationTime(compilationMXBean.getTotalCompilationTime());
            }
            jvmMonitorEntity.setCompilationBean(compilationBean);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        try {
            Double systemLoadAverage = operatingSystemMXBean.getSystemLoadAverage();
            BeanUtils.copyProperties((Object)operatingSystemMXBean, (Object)operatingSystemBean);
            operatingSystemBean.setSystemLoadAverage(systemLoadAverage);
            long totalPhysicalMemorySize = JvmLoggerTask.getLongFromOperatingSystem(operatingSystemMXBean, "getTotalPhysicalMemorySize");
            long freePhysicalMemorySize = JvmLoggerTask.getLongFromOperatingSystem(operatingSystemMXBean, "getFreePhysicalMemorySize");
            long usedPhysicalMemorySize = totalPhysicalMemorySize - freePhysicalMemorySize;
            long totalSwapSpaceSize = JvmLoggerTask.getLongFromOperatingSystem(operatingSystemMXBean, "getTotalSwapSpaceSize");
            long freeSwapSpaceSize = JvmLoggerTask.getLongFromOperatingSystem(operatingSystemMXBean, "getFreeSwapSpaceSize");
            long usedSwapSpaceSize = totalSwapSpaceSize - freeSwapSpaceSize;
            operatingSystemBean.setTotalPhysicalMemorySize(totalPhysicalMemorySize);
            operatingSystemBean.setFreePhysicalMemorySize(freePhysicalMemorySize);
            operatingSystemBean.setUsedPhysicalMemorySize(usedPhysicalMemorySize);
            operatingSystemBean.setTotalSwapSpaceSize(totalSwapSpaceSize);
            operatingSystemBean.setUsedSwapSpaceSize(usedSwapSpaceSize);
            operatingSystemBean.setFreeSwapSpaceSize(freeSwapSpaceSize);
            jvmMonitorEntity.setOperatingSystemBean(operatingSystemBean);
            String pid = runtimeMXBean.getName().split("@")[0];
            if (!StringUtil.isEmpty((String)pid)) {
                runtimeBean.setProcessId(pid);
            }
            float processUsage = this.localLogMetricsEndpoint.getMetricByProcessCpuUsage().floatValue();
            runtimeBean.setProcessUsage(Float.valueOf(processUsage));
            BeanUtils.copyProperties((Object)runtimeMXBean, (Object)runtimeBean);
            runtimeBean.setInputArguments(JSON.toJSONString(runtimeMXBean.getInputArguments()));
            jvmMonitorEntity.setRuntimeBean(runtimeBean);
            BeanUtils.copyProperties((Object)threadMXBean, (Object)threadBean);
            jvmMonitorEntity.setThreadBean(threadBean);
        }
        catch (BeansException e) {
            log.error("", (Throwable)e);
        }
        BeanUtils.copyProperties((Object)heapMemoryUsage, (Object)heapMemoryUsageBean);
        BeanUtils.copyProperties((Object)nonHeapMemoryUsage, (Object)nonHeapMemoryUsageBean);
        try {
            Long userRate1 = heapMemoryUsage.getUsed() * 100L / heapMemoryUsage.getCommitted();
            heapMemoryUsageBean.setUserRate(userRate1);
            Long userRate2 = nonHeapMemoryUsage.getUsed() * 100L / nonHeapMemoryUsage.getCommitted();
            nonHeapMemoryUsageBean.setUserRate(userRate2);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        memoryBean.setHeapMemoryUsage(heapMemoryUsageBean);
        memoryBean.setNonHeapMemoryUsage(nonHeapMemoryUsageBean);
        jvmMonitorEntity.setMemoryBean(memoryBean);
        jvmMonitorEntity.setTimestamp(new Date().getTime());
        return jvmMonitorEntity;
    }

    private static long getLongFromOperatingSystem(OperatingSystemMXBean operatingSystem, String methodName) {
        try {
            Method method = operatingSystem.getClass().getMethod(methodName, null);
            method.setAccessible(true);
            return (Long)method.invoke((Object)operatingSystem, (Object[])null);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new IllegalStateException(e.getCause());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private void writeLog() {
        log.debug("begin to collect jvm  monitor data");
        JvmMonitorEntity jvmMonitorEntity = this.printJvmAllInfo();
        try {
            JvmLogger.info(jvmMonitorEntity);
        }
        catch (Exception e) {
            log.error("jvm monitor info get error", (Throwable)e);
        }
    }

    protected String getCron() {
        return this.cron;
    }
}

