/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.log.dbpool.collect;

import cn.com.yusys.yusp.commons.log.dbpool.constant.DbPoolConstant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.MetricsEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.util.CollectionUtils;

public class LocalLogDbPoolMetricsEndpoint {
    private final Logger log = LoggerFactory.getLogger(LocalLogDbPoolMetricsEndpoint.class);
    @Autowired
    private MetricsEndpoint metricsEndpoint;

    @ConditionalOnMissingBean
    public LocalLogDbPoolMetricsEndpoint restLocalLogDbPoolMetricsEndpoint() {
        return new LocalLogDbPoolMetricsEndpoint();
    }

    public Map<String, Object> getDbPoolEntityByDbParams() {
        List list = DbPoolConstant.getEnumList(DbPoolConstant.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (DbPoolConstant dbPoolConstant : list) {
            String namne = dbPoolConstant.getName();
            try {
                MetricsEndpoint.MetricResponse metricResponse = this.metricsEndpoint.metric(namne, null);
                if (metricResponse == null) continue;
                map.put(dbPoolConstant.getCname(), metricResponse);
            }
            catch (Exception e) {
                this.log.error("dbpool exception", (Throwable)e);
            }
        }
        if (CollectionUtils.isEmpty(map)) {
            this.log.info("dbpool monitor info is null!");
        }
        return map;
    }
}

