/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.core.thread;

import cn.com.yusys.yusp.commons.job.core.biz.AdminBiz;
import cn.com.yusys.yusp.commons.job.core.biz.model.HandleCallbackParam;
import cn.com.yusys.yusp.commons.job.core.biz.model.ReturnT;
import cn.com.yusys.yusp.commons.job.core.executor.XxlJobExecutor;
import cn.com.yusys.yusp.commons.job.core.log.JobFileAppender;
import cn.com.yusys.yusp.commons.job.core.log.JobLogger;
import cn.com.yusys.yusp.commons.job.core.rpc.serialize.HessianSerializer;
import cn.com.yusys.yusp.commons.job.core.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerCallbackThread {
    private static Logger logger = LoggerFactory.getLogger(TriggerCallbackThread.class);
    private static TriggerCallbackThread instance = new TriggerCallbackThread();
    private LinkedBlockingQueue<HandleCallbackParam> callBackQueue = new LinkedBlockingQueue();
    private Thread triggerCallbackThread;
    private Thread triggerRetryCallbackThread;
    private volatile boolean toStop = false;
    private static String failCallbackFilePath = JobFileAppender.getLogPath().concat(File.separator).concat("callbacklog").concat(File.separator);
    private static String failCallbackFileName = failCallbackFilePath.concat("xxl-job-callback-{x}").concat(".log");

    public static TriggerCallbackThread getInstance() {
        return instance;
    }

    public static void pushCallBack(HandleCallbackParam callback) {
        TriggerCallbackThread.getInstance().callBackQueue.add(callback);
        logger.debug(">>>>>>>>>>> job, push callback request, logId:{}", (Object)callback.getLogId());
    }

    public void start() {
        if (XxlJobExecutor.getAdminBizList() == null) {
            logger.warn(">>>>>>>>>>> job, executor callback config fail, adminAddresses is null.");
            return;
        }
        this.triggerCallbackThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!TriggerCallbackThread.this.toStop) {
                    try {
                        HandleCallbackParam callback = (HandleCallbackParam)TriggerCallbackThread.getInstance().callBackQueue.take();
                        if (callback == null) continue;
                        ArrayList<HandleCallbackParam> callbackParamList = new ArrayList<HandleCallbackParam>();
                        int drainToNum = TriggerCallbackThread.getInstance().callBackQueue.drainTo(callbackParamList);
                        callbackParamList.add(callback);
                        if (callbackParamList == null || callbackParamList.size() <= 0) continue;
                        TriggerCallbackThread.this.doCallback(callbackParamList);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    ArrayList callbackParamList = new ArrayList();
                    int drainToNum = TriggerCallbackThread.getInstance().callBackQueue.drainTo(callbackParamList);
                    if (callbackParamList != null && callbackParamList.size() > 0) {
                        TriggerCallbackThread.this.doCallback(callbackParamList);
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                logger.info(">>>>>>>>>>> job, executor callback thread destory.");
            }
        });
        this.triggerCallbackThread.setDaemon(true);
        this.triggerCallbackThread.start();
        this.triggerRetryCallbackThread = new Thread(() -> {
            while (!this.toStop) {
                block5: {
                    try {
                        this.retryFailCallbackFile();
                    }
                    catch (Exception e) {
                        if (this.toStop) break block5;
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    TimeUnit.SECONDS.sleep(30L);
                }
                catch (InterruptedException e) {
                    if (this.toStop) continue;
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            logger.info(">>>>>>>>>>> xxl-job, executor retry callback thread destory.");
        });
        this.triggerRetryCallbackThread.setDaemon(true);
        this.triggerRetryCallbackThread.start();
    }

    public void toStop() {
        this.toStop = true;
        this.triggerCallbackThread.interrupt();
        try {
            this.triggerCallbackThread.join();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void doCallback(List<HandleCallbackParam> callbackParamList) {
        boolean callbackRet = false;
        for (AdminBiz adminBiz : XxlJobExecutor.getAdminBizList()) {
            try {
                ReturnT<String> callbackResult = adminBiz.callback(callbackParamList);
                if (callbackResult != null && "200".equals(callbackResult.getCode())) {
                    this.callbackLog(callbackParamList, "<br>----------- xxl-job job callback finish.");
                    callbackRet = true;
                    break;
                }
                this.callbackLog(callbackParamList, "<br>----------- xxl-job job callback fail, callbackResult:" + callbackResult);
            }
            catch (Exception e) {
                this.callbackLog(callbackParamList, "<br>----------- xxl-job job callback error, errorMsg:" + e.getMessage());
            }
        }
        if (!callbackRet) {
            this.appendFailCallbackFile(callbackParamList);
        }
    }

    private void callbackLog(List<HandleCallbackParam> callbackParamList, String logContent) {
        for (HandleCallbackParam callbackParam : callbackParamList) {
            String logFileName = JobFileAppender.makeLogFileName(new Date(callbackParam.getLogDateTim()), callbackParam.getLogId());
            JobFileAppender.contextHolder.set(logFileName);
            JobLogger.log(logContent, new Object[0]);
        }
    }

    private void appendFailCallbackFile(List<HandleCallbackParam> callbackParamList) {
        if (callbackParamList == null || callbackParamList.size() == 0) {
            return;
        }
        XxlJobExecutor.getSerializer();
        byte[] callbackParamList_bytes = HessianSerializer.serialize(callbackParamList);
        File callbackLogFile = new File(failCallbackFileName.replace("{x}", String.valueOf(System.currentTimeMillis())));
        if (callbackLogFile.exists()) {
            for (int i = 0; i < 100 && (callbackLogFile = new File(failCallbackFileName.replace("{x}", String.valueOf(System.currentTimeMillis()).concat("-").concat(String.valueOf(i))))).exists(); ++i) {
            }
        }
        FileUtil.writeFileContent(callbackLogFile, callbackParamList_bytes);
    }

    private void retryFailCallbackFile() {
        File callbackLogPath = new File(failCallbackFilePath);
        if (!callbackLogPath.exists()) {
            return;
        }
        if (callbackLogPath.isFile()) {
            callbackLogPath.delete();
        }
        if (!callbackLogPath.isDirectory() || callbackLogPath.list() == null || callbackLogPath.list().length <= 0) {
            return;
        }
        for (File callbaclLogFile : callbackLogPath.listFiles()) {
            byte[] callbackParamList_bytes = FileUtil.readFileContent(callbaclLogFile);
            XxlJobExecutor.getSerializer();
            List callbackParamList = (List)HessianSerializer.deserialize(callbackParamList_bytes, HandleCallbackParam.class);
            callbaclLogFile.delete();
            this.doCallback(callbackParamList);
        }
    }
}

