/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.core.thread;

import cn.com.yusys.yusp.commons.job.core.biz.AdminBiz;
import cn.com.yusys.yusp.commons.job.core.biz.model.RegistryParam;
import cn.com.yusys.yusp.commons.job.core.biz.model.ReturnT;
import cn.com.yusys.yusp.commons.job.core.enums.RegistryConfig;
import cn.com.yusys.yusp.commons.job.core.executor.XxlJobExecutor;
import cn.com.yusys.yusp.commons.job.core.util.IpUtil;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorRegistryThread
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(ExecutorRegistryThread.class);
    private static ExecutorRegistryThread instance = new ExecutorRegistryThread();
    private Thread registryThread;
    private volatile boolean toStop = false;

    public static ExecutorRegistryThread getInstance() {
        return instance;
    }

    public void start(int port, String ip, final String appName) {
        if (appName == null || appName.trim().length() == 0) {
            logger.warn(">>>>>>>>>>> job, executor registry config fail, appName is null.");
            return;
        }
        if (XxlJobExecutor.getAdminBizList() == null) {
            logger.warn(">>>>>>>>>>> job, executor registry config fail, adminAddresses is null.");
            return;
        }
        final String executorAddress = ip != null && ip.trim().length() > 0 ? ip.trim().concat(":").concat(String.valueOf(port)) : IpUtil.getIpPort(port);
        this.registryThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ReturnT<String> registryResult;
                RegistryParam registryParam;
                while (!ExecutorRegistryThread.this.toStop) {
                    try {
                        registryParam = new RegistryParam(RegistryConfig.RegistType.EXECUTOR.name(), appName, executorAddress);
                        for (AdminBiz adminBiz : XxlJobExecutor.getAdminBizList()) {
                            try {
                                registryResult = adminBiz.registry(registryParam);
                                if (registryResult != null && "200".equals(registryResult.getCode())) {
                                    registryResult = ReturnT.SUCCESS;
                                    logger.debug(">>>>>>>>>>> job registry success, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                                    break;
                                }
                                logger.debug(">>>>>>>>>>> job registry fail, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                            }
                            catch (Exception e) {
                                logger.error(">>>>>>>>>>> job registry error, registryParam:{}", (Object)registryParam, (Object)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    try {
                        TimeUnit.SECONDS.sleep(30L);
                    }
                    catch (InterruptedException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    registryParam = new RegistryParam(RegistryConfig.RegistType.EXECUTOR.name(), appName, executorAddress);
                    for (AdminBiz adminBiz : XxlJobExecutor.getAdminBizList()) {
                        try {
                            registryResult = adminBiz.registryRemove(registryParam);
                            if (registryResult != null && "200".equals(registryResult.getCode())) {
                                registryResult = ReturnT.SUCCESS;
                                logger.debug(">>>>>>>>>>> job registry-remove success, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                                break;
                            }
                            logger.error(">>>>>>>>>>> job registry-remove fail, registryParam:{}, registryResult:{}", new Object[]{registryParam, registryResult});
                        }
                        catch (Exception e) {
                            logger.error(">>>>>>>>>>> job registry-remove error, registryParam:{}", (Object)registryParam, (Object)e);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                logger.info(">>>>>>>>>>> job, executor registry thread destory.");
            }
        });
        this.registryThread.setDaemon(true);
        this.registryThread.start();
    }

    public void toStop() {
        this.toStop = true;
        this.registryThread.interrupt();
        try {
            this.registryThread.join();
        }
        catch (InterruptedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

