/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.core.rpc.netcom;

import cn.com.yusys.yusp.commons.job.core.biz.model.ReturnT;
import cn.com.yusys.yusp.commons.job.core.rpc.codec.RpcRequest;
import cn.com.yusys.yusp.commons.job.core.rpc.codec.RpcResponse;
import cn.com.yusys.yusp.commons.job.core.rpc.netcom.jetty.server.JettyServer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.reflect.FastClass;
import org.springframework.cglib.reflect.FastMethod;

public class NetComServerFactory {
    private static final Logger logger = LoggerFactory.getLogger(NetComServerFactory.class);
    JettyServer server = new JettyServer();
    private static Map<String, Object> serviceMap = new HashMap<String, Object>();
    private static String accessToken;

    public void start(int port, String ip, String appName) throws Exception {
        this.server.start(port, ip, appName);
    }

    public void destroy() {
        this.server.destroy();
    }

    public static void putService(Class<?> iface, Object serviceBean) {
        serviceMap.put(iface.getName(), serviceBean);
    }

    public static void setAccessToken(String accessToken) {
        NetComServerFactory.accessToken = accessToken;
    }

    public static RpcResponse invokeService(RpcRequest request, Object serviceBean) {
        logger.debug("Server begin===================================================================");
        logger.debug("request,{}", (Object)request);
        if (serviceBean == null) {
            serviceBean = serviceMap.get(request.getClassName());
        }
        if (serviceBean == null) {
            // empty if block
        }
        RpcResponse response = new RpcResponse();
        long currentTime = System.currentTimeMillis();
        logger.debug(">>>>>>>>>>>>>>>>>>>>>>>>>>>>currentTime:{}, getCreateMillisTime:{}", (Object)currentTime, (Object)request.getCreateMillisTime());
        if (currentTime - Long.parseLong(request.getCreateMillisTime()) > 180000L) {
            logger.error(">>>>>>>>>>>>>>>>>>>>>>>>>>>>now1:{},- now2:{} > 180000,\u68c0\u67e5\u7cfb\u7edf\u4e4b\u95f4\u7684\u6807\u51c6\u65f6\u95f4\u662f\u5426\u4e00\u81f4", (Object)currentTime, (Object)request.getCreateMillisTime());
            response.setResult(new ReturnT("500", "The timestamp difference between admin and executor exceeds the limit."));
            return response;
        }
        try {
            Class<?> serviceClass = serviceBean.getClass();
            String methodName = request.getMethodName();
            Class[] parameterTypes = request.getParameterTypes();
            Object[] parameters = request.getParameters();
            FastClass serviceFastClass = FastClass.create(serviceClass);
            FastMethod serviceFastMethod = serviceFastClass.getMethod(methodName, parameterTypes);
            Object result = serviceFastMethod.invoke(serviceBean, parameters);
            response.setResult(result);
        }
        catch (Throwable t) {
            t.printStackTrace();
            response.setError(t.getMessage());
        }
        logger.debug("response,{}", (Object)response);
        logger.debug("Server end===================================================================");
        return response;
    }
}

