/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.job.config;

import cn.com.yusys.yusp.commons.job.core.executor.XxlJobExecutor;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"application.xxl.job.enabled"}, havingValue="true")
public class XxlJobClientAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(XxlJobClientAutoConfiguration.class);
    @Value(value="${application.xxl.job.admin.addresses}")
    private String adminAddresses;
    @Value(value="${application.xxl.job.executor.appname}")
    private String appName;
    @Value(value="${application.xxl.job.executor.ip}")
    private String ip;
    @Value(value="${application.xxl.job.executor.port}")
    private int port;
    @Value(value="${application.xxl.job.executor.logpath}")
    private String logPath;
    @Value(value="${application.xxl.job.executor.logretentiondays}")
    private int logRetentionDays;

    @Bean(destroyMethod="destroy")
    public XxlJobExecutor xxlJobExecutor() throws IOException {
        logger.info(">>>>>>>>>>> xxl-job config init.");
        XxlJobExecutor xxlJobExecutor = new XxlJobExecutor();
        xxlJobExecutor.setAdminAddresses(this.adminAddresses);
        xxlJobExecutor.setAppName(this.appName);
        xxlJobExecutor.setIp(this.ip);
        xxlJobExecutor.setPort(this.port);
        xxlJobExecutor.setLogPath(this.logPath);
        xxlJobExecutor.setLogRetentionDays(this.logRetentionDays);
        return xxlJobExecutor;
    }

    @Component
    public class XxlJobStartup
    implements ApplicationRunner,
    ApplicationContextAware {
        private ApplicationContext ctx = null;

        public void run(ApplicationArguments args) throws Exception {
            XxlJobExecutor executor = (XxlJobExecutor)this.ctx.getBean(XxlJobExecutor.class);
            try {
                executor.start();
            }
            catch (Exception e) {
                logger.error("xxl-job \u542f\u52a8\u5931\u8d25!", (Throwable)e);
                throw new RuntimeException(e);
            }
            logger.info("xxl-job \u542f\u52a8\u6210\u529f!");
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.ctx = applicationContext;
        }
    }
}

